<?php

add_action('init', 'SLIDE_SWP_create_artist_post', 8);
function SLIDE_SWP_create_artist_post() 
{
	$slug = SLIDE_SWP_JPT_get_plugin_option("artist");
	if ("" == $slug) {
		$slug = "js_artist";
	}
	
	register_post_type('js_artist',
		array(
			'labels' => array(
				'name' =>  esc_html__('Artists', 'slide-music-core') ,
				'singular_name' =>  esc_html__('Artist', 'slide-music-core') ,
				'add_new' => esc_html__('Add New Artist', 'slide-music-core'),
				'add_new_item' => esc_html__('Add New Artist', 'slide-music-core'),
				'edit' => esc_html__('Edit', 'slide-music-core'),
				'edit_item' => esc_html__('Edit Artist', 'slide-music-core'),
				'new_item' => esc_html__('New Artist', 'slide-music-core'),
				'view' => esc_html__('View', 'slide-music-core'),
				'view_item' => esc_html__('View Artist', 'slide-music-core'),
				'search_items' => esc_html__('Search Artists', 'slide-music-core'),
				'not_found' => esc_html__('No Artist Found','slide-music-core'),
				'not_found_in_trash' => esc_html__('No Event Found in Trash','slide-music-core'),
				'parent' => esc_html__('Parent Artist','slide-music-core')
			),
		'public' => true,
		'rewrite' => array(
			'slug' => $slug,
			'with_front' => false
			),
		'supports' => array('title', 'editor', 'comments', 'thumbnail'),
		'menu_icon' => 'dashicons-admin-users',
		)
	); 
}

/*
	Add metabox
*/

add_action('admin_init', 'SLIDE_SWP_artist_admin_init');
function SLIDE_SWP_artist_admin_init() 
{
	/* artist information */
    add_meta_box('artist_meta_box', 			/*the required HTML id attribute*/
        esc_html__('Artist Settings','slide-music-core'), 		/*text visible in the heading of meta box section*/
        'SLIDE_SWP_display_artist_meta_box',				/* callback FUNCTION which renders the contents of the meta box*/
        'js_artist', 							/*the name of the custom post type where the meta box will be displayed*/
		'normal', 								/*defines the part of the page where the edit screen section should be shown*/
		'high' 									/*defines the priority within the context where the boxes should show*/
   );
}

function SLIDE_SWP_display_artist_meta_box($artistObject) {
	$artist_id = $artistObject->ID;

	/*general options*/
	$artist_nickname = esc_html(get_post_meta($artist_id, 'artist_nickname', true));
	$artist_website = esc_url(get_post_meta($artist_id, 'artist_website', true));

	/*social options*/
	$artist_facebook = esc_url(get_post_meta($artist_id, 'artist_facebook', true));
	$artist_twitter = esc_url(get_post_meta($artist_id, 'artist_twitter', true));
	$artist_instagram = esc_url(get_post_meta($artist_id, 'artist_instagram', true));
	$artist_soundcloud = esc_url(get_post_meta($artist_id, 'artist_soundcloud', true));
	$artist_youtube = esc_url(get_post_meta($artist_id, 'artist_youtube', true));

	/*how to align image*/
	$artist_img_align = esc_html(get_post_meta($artist_id, 'artist_img_align', true));
	if (empty($artist_img_align)) {
		$artist_img_align = "top";
	}
	$artist_img_align_opts = array( 
			esc_html__("Top", "slide-music-core") => "top",
			esc_html__("Center", "slide-music-core") => "center",
			esc_html__("Bottom", "slide-music-core") => "bottom"
	);

?>
	<table class= "swp_artist_cpt_opts swp_cpt_opts">
		<tr>
            <td class="swp_setting_name">
            	<?php echo esc_html__('Nickname', 'slide-music-core');?>
            </td>
			<td>
				<input class="swp_cpt_setting_input" type="text" name="artist_nickname" value="<?php echo esc_attr($artist_nickname); ?>" />
				<div class="description swp_cpt_setting_desc">
					<?php echo esc_html__('Artist nickname, or position in the band, ex: [bass player].', 'slide-music-core'); ?>
				</div>
			</td>
        </tr>

		<tr>
            <td class="swp_setting_name">
            	<?php echo esc_html__('Artist Website', 'slide-music-core');?>
            </td>
			<td>
				<input class="swp_cpt_setting_input" type="text" name="artist_website" value="<?php echo esc_attr($artist_website); ?>" />
				<div class="description swp_cpt_setting_desc">
					<?php echo esc_html__('The URL to the artist website.', 'slide-music-core'); ?>
				</div>
			</td>
        </tr>

		<tr>
            <td class="swp_setting_name">
            	<?php echo esc_html__('Artist Facebook URL', 'slide-music-core');?>
            </td>
			<td>
				<input class="swp_cpt_setting_input" type="text" name="artist_facebook" value="<?php echo esc_attr($artist_facebook); ?>" />
				<div class="description swp_cpt_setting_desc">
					<?php echo esc_html__('The URL to the artist Facebook profile.', 'slide-music-core'); ?>
				</div>
			</td>
        </tr>

		<tr>
            <td class="swp_setting_name">
            	<?php echo esc_html__('Artist Twitter URL', 'slide-music-core');?>
            </td>
			<td>
				<input class="swp_cpt_setting_input" type="text" name="artist_twitter" value="<?php echo esc_attr($artist_twitter); ?>" />
				<div class="description swp_cpt_setting_desc">
					<?php echo esc_html__('The URL to the artist Twitter profile.', 'slide-music-core'); ?>
				</div>
			</td>
        </tr>

		<tr>
            <td class="swp_setting_name">
            	<?php echo esc_html__('Artist Instagram URL', 'slide-music-core');?>
            </td>
			<td>
				<input class="swp_cpt_setting_input" type="text" name="artist_instagram" value="<?php echo esc_attr($artist_instagram); ?>" />
				<div class="description swp_cpt_setting_desc">
					<?php echo esc_html__('The URL to the artist Instagram profile.', 'slide-music-core'); ?>
				</div>
			</td>
        </tr> 

		<tr>
            <td class="swp_setting_name">
            	<?php echo esc_html__('Artist SoundCloud URL', 'slide-music-core');?>
            </td>
			<td>
				<input class="swp_cpt_setting_input" type="text" name="artist_soundcloud" value="<?php echo esc_attr($artist_soundcloud); ?>" />
				<div class="description swp_cpt_setting_desc">
					<?php echo esc_html__('The URL to the artist SoundCloud profile.', 'slide-music-core'); ?>
				</div>
			</td>
        </tr>

		<tr>
            <td class="swp_setting_name">
            	<?php echo esc_html__('Artist YouTube URL', 'slide-music-core');?>
            </td>
			<td>
				<input class="swp_cpt_setting_input" type="text" name="artist_youtube" value="<?php echo esc_attr($artist_youtube); ?>" />
				<div class="description swp_cpt_setting_desc">
					<?php echo esc_html__('The URL to the artist YouTube profile.', 'slide-music-core'); ?>
				</div>
			</td>
        </tr>

		<tr>
            <td class="swp_setting_name">
            	<?php echo esc_html__('Vertically align artist image', 'slide-music-core');?>
            </td>
			<td>
        		<select id="artist_img_align" name="artist_img_align">
        			<?php LMC_SWP_render_select_options($artist_img_align_opts, $artist_img_align); ?>
        		</select>

				<div class="description swp_cpt_setting_desc">
					<?php echo esc_html__('Choose how to aligh the artist image when used on a visual composer element or for artist archive page.', 'slide-music-core'); ?>
				</div>
			</td>
        </tr>        
	</table>
<?php
}

add_action('save_post', 'SLIDE_SWP_save_artist_fields', 10, 2);
function SLIDE_SWP_save_artist_fields($artist_id, $artistObject) {
	if ($artistObject->post_type != 'js_artist') {
		return;
	}

	if (isset($_POST['artist_nickname'])) {
		update_post_meta($artist_id, 'artist_nickname', $_POST['artist_nickname']);
	}
	if (isset($_POST['artist_website'])) {
		update_post_meta($artist_id, 'artist_website', $_POST['artist_website']);
	}
	if (isset($_POST['artist_facebook'])) {
		update_post_meta($artist_id, 'artist_facebook', $_POST['artist_facebook']);
	}
	if (isset($_POST['artist_twitter'])) {
		update_post_meta($artist_id, 'artist_twitter', $_POST['artist_twitter']);
	}
	if (isset($_POST['artist_instagram'])) {
		update_post_meta($artist_id, 'artist_instagram', $_POST['artist_instagram']);
	}
	if (isset($_POST['artist_soundcloud'])) {
		update_post_meta($artist_id, 'artist_soundcloud', $_POST['artist_soundcloud']);
	}
	if (isset($_POST['artist_youtube'])) {
		update_post_meta($artist_id, 'artist_youtube', $_POST['artist_youtube']);
	}
	if (isset($_POST['artist_img_align'])) {
		update_post_meta($artist_id, 'artist_img_align', $_POST['artist_img_align']);
	}
}


/*
	Adding custom columns to admin menu using filter  [manage_edit-{post_type}_columns]
*/
add_filter('manage_edit-js_artist_columns', 'SLIDE_SWP_artist_admin_columns_func');

function SLIDE_SWP_artist_admin_columns_func($columns)
{
	$columns = array(
		'cb'	=> '<input type="checkbox" />',
		'title' => esc_html__('Artist Name', 'slide-music-core'),
		'date'		=> esc_html__('Date', 'slide-music-core')		
	);
	
	return $columns;
}


/*
	Fill the custom columns on admin - not needed
*/


/*
	Create Category for Events
*/
add_action('init', 'SLIDE_SWP_create_artist_category', 11);

function SLIDE_SWP_create_artist_category()
{
	$slug = SLIDE_SWP_JPT_get_plugin_option("artist_tax");
	if ("" == $slug) {
		$slug = "artist_category";
	}
	
	register_taxonomy(
			'artist_category',
			'js_artist',
			array(
				'labels' => array(
					'name' => esc_html__('Artist Categories', 'slide-music-core'),
					'singular_name'     => esc_html__('Artist Category', 'slide-music-core'),
					'search_items'      => esc_html__('Search Artist Categories', 'slide-music-core' ),
					'all_items'         => esc_html__('All Artist Categories', 'slide-music-core' ),
					'parent_item'       => esc_html__('Parent Artist Category', 'slide-music-core' ),
					'parent_item_colon' => esc_html__('Parent Artist Category:', 'slide-music-core' ),
					'edit_item'         => esc_html__('Edit Artist Category', 'slide-music-core' ),
					'update_item'       => esc_html__('Update Artist Category', 'slide-music-core' ),
					'add_new_item' 		=> esc_html__('Add New Artist Category', 'slide-music-core'),
					'new_item_name' 	=> esc_html__('New Artist Category', 'slide-music-core'),
				),
				'rewrite' => array(
					'slug' => $slug,
					'with_front' => false
				),
				'show_ui' => true,
				'show_tagcloud' => false,
				'hierarchical' => true
			)
		);
}