<?php
/*
	Add new params to vc row
*/

if (function_exists('vc_add_param'))
{
	vc_add_param( "vc_row", array(
		"type"			=> "colorpicker",
		"class"			=> "",
		"heading"		=> esc_html__("Color Overlay", "slide-music-core"),
		"param_name"	=> "js_color_overlay",
		"value"			=> "",
		"description"	=> esc_html__("Use a color overlay over the background image", "slide-music-core")
	));
	
	vc_add_param( "vc_row", array(
		"type"			=> "dropdown",
		"class"			=> "",
		"heading"		=> esc_html__("Color Scheme", 'slide'),
		"param_name"	=> "lc_swp_row_color_scheme",
		"value"			=> array(
						esc_html__("Theme Settings Default", "slide-music-core")	=> "theme_default",
						esc_html__("White On Black", "slide-music-core")			=> "white_on_black",
						esc_html__("Black On White", "slide-music-core")			=> "black_on_white"
						),
		"description"	=> esc_html__("Add a custom color scheme that will overwrite the option in Appearance - Slide Settings - General. This is an option added by Slide theme", "slide-music-core")
	));

	vc_add_param( "vc_row", array(
		"type"			=> "dropdown",
		"class"			=> "",
		"heading"		=> esc_html__("Boxed Width", 'slide'),
		"param_name"	=> "lc_swp_row_boxed_width",
		"value"			=> array(
						esc_html__("Default", "slide-music-core")	=> "default",
						esc_html__("Force Boxed", "slide-music-core")			=> "force_boxed"
						),
		"description"	=> esc_html__("Force boxed width for this row.", "slide-music-core")
	));

	vc_add_param( "vc_row_inner", array(
		"type"			=> "dropdown",
		"class"			=> "",
		"heading"		=> esc_html__("Boxed Width", 'slide'),
		"param_name"	=> "lc_swp_row_boxed_width",
		"value"			=> array(
						esc_html__("Default", "slide-music-core")	=> "default",
						esc_html__("Force Boxed", "slide-music-core")			=> "force_boxed"
						),
		"description"	=> esc_html__("Force boxed width for this row.", "slide-music-core")
	));		
}
