<?php

/* 
|--------------------------------------------------------------------------
| ADD META BOXES
|--------------------------------------------------------------------------
*/
function SLIDE_SWP_custom_meta_boxes() {

	/* CUSTOM BACKGROUND IMAGE*/
	$custom_bg_image_support = array('post', 'page', 'js_albums', 'js_events', 'js_photo_albums', 'js_videos', 'js_artist');
	foreach($custom_bg_image_support as $post_type) {
		add_meta_box( 
			'js_swp_custom_bg_meta', 
			esc_html__("Page Settings", 'slide-music-core'),
			'SLIDE_SWP_custom_bg_meta_callback',  
			$post_type
		);
		add_meta_box(
			'js_swp_custom_header_meta', 
			esc_html__("Header Settings", 'slide-music-core'), 
			'SLIDE_SWP_custom_header_meta_callback',
			$post_type
		);
	}

	/*get the current page template*/
	global $post;
	$post_id = $post->ID;
	$page_template = get_post_meta($post_id,'_wp_page_template', TRUE);

	/*add custom meta to discography page*/
	if ('template-discography.php' == $page_template) {
		add_meta_box(
			"js_swp_discography_settings_meta", 
			esc_html__("Discography Settings - Slide Theme", 'slide-music-core'), 
			"SLIDE_SWP_discography_settings_cbk", 
			"page");		
	}

	/*
	add custom meta box to:
	- events
	- videos
	- albums
	where the user can select one or more artists that will be assigned to certain post type
	*/
	$artist_select_support = array('js_albums', 'js_events', 'js_videos');
	foreach($artist_select_support as $post_type) {
		add_meta_box( 
			'js_swp_artist_select_meta', 
			esc_html__("Artist Selection", 'slide-music-core'),
			'SLIDE_SWP_artist_select_meta_callback',  
			$post_type,
			'advanced',		/*context*/
			'high'			/*priority*/
		);
	}

	$show_cpt_cat_support = array(
				'template-artists.php', 
				'template-discography.php',
				'template-events-all.php',
				'template-events-past.php',
				'template-events-upcoming.php',
				'template-photo-gallery.php',
				'template-videos.php');
	if (in_array($page_template, $show_cpt_cat_support)) {
		add_meta_box( 
			'js_swp_show_cpt_cat_meta', 
			esc_html__("Show Categories Under The Page Title ", 'slide-music-core'),
			'SLIDE_SWP_show_cpt_cat_meta_callback',  
			"page",
			'advanced',		/*context*/
			'high'			/*priority*/
		);
	}	
}
add_action('add_meta_boxes', 'SLIDE_SWP_custom_meta_boxes');

/* 
|--------------------------------------------------------------------------
| CALLBACK FUNCTION THAT RENDERS META
|--------------------------------------------------------------------------
*/
/*custom page background*/
function SLIDE_SWP_custom_bg_meta_callback($post) {
	
    $js_swp_stored_meta = get_post_meta($post->ID);
	$meta_bg = '';
	$page_overlay_color = '';
	$remove_footer_widgets = '';
	if (isset($js_swp_stored_meta['js_swp_meta_bg_image'])) {
		$meta_bg = $js_swp_stored_meta['js_swp_meta_bg_image'][0];
	}
	if (isset($js_swp_stored_meta['lc_swp_meta_page_overlay_color'])) {
		$page_overlay_color = $js_swp_stored_meta['lc_swp_meta_page_overlay_color'][0];
	}
	if (isset($js_swp_stored_meta['lc_swp_meta_page_remove_footer'])) {
		$remove_footer_widgets = $js_swp_stored_meta['lc_swp_meta_page_remove_footer'][0];
	}
	$page_color_theme = 'settings_default';
	if (isset($js_swp_stored_meta['lc_swp_meta_page_color_theme'])) {
		$page_color_theme = $js_swp_stored_meta['lc_swp_meta_page_color_theme'][0];
	}
	
	$page_color_themes_support = array(
		'Default'			=> 'settings_default',
		'White On Black'	=> 'white_on_black',
		'Black On White'	=>	'black_on_white'
	);	

	wp_nonce_field( basename( __FILE__ ), 'js_swp_nonce' );
	ob_start();
?>	
	<div class="heading_meta_option">
		<span class="lc_swp_before_option">
			<?php echo esc_html__('Choose custom page background image:', 'slide-music-core'); ?>
		</span>
		<input type="text" style="width:100%; margin-bottom: 5px;" name="js_swp_meta_bg_image" id="js_swp_meta_bg_image" value="<?php echo esc_attr($meta_bg); ?>" />
		<div class="js_swp_meta_bg_image_buttons">
			<input type="button" id="js_swp_meta_bg_image-button" class="button" value="<?php echo esc_html__('Choose Image', 'slide-music-core'); ?>" />
			<input type="button" id="js_swp_meta_bg_image-buttondelete" class="button" value="<?php echo esc_html__('Remove Image', 'slide-music-core'); ?>" />
		</div>
	</div>
	<div id="custom_bg_meta_preview">
		<img style="max-width:100%;" src="<?php echo esc_url($meta_bg); ?>" />
    </div>
	<div class="heading_meta_option">
		<span class="lc_swp_before_option">
			<?php echo esc_html__('Page background color overlay:', 'slide-music-core'); ?>
		</span>
		<div class="lc_swp_option_right">
			<input type="text" class="lc_swp_option alpha-color-picker" name="lc_swp_meta_page_overlay_color" value="<?php echo esc_attr($page_overlay_color); ?>" data-default-color="rgba(0,0,0,0)" data-show-opacity="true" />
		</div>
	</div>
	<div class="heading_meta_option">
		<span class="lc_swp_before_option">
			<?php echo esc_html__('Color Scheme:', 'slide-music-core'); ?>
		</span>
		<select id="lc_swp_meta_page_color_theme" name="lc_swp_meta_page_color_theme">
		<?php
			foreach($page_color_themes_support as $key => $value) {
				if ($value == $page_color_theme) {
					?>
					<option value="<?php echo esc_attr($value); ?>" selected="selected"> <?php echo esc_html($key); ?> </option>
					<?php
				} else {
					?>
					<option value="<?php echo esc_attr($value); ?>"> <?php echo esc_html($key); ?> </option>
					<?php
				}
			}
		?>
		</select>
		<p class="description show_on_right">
			<?php echo esc_html__('Choose a color scheme for this individual page to overwrite the global settings in Appearance - Slide Settings.', 'slide-music-core'); ?>
		</p>
	</div>	
	<div class="heading_meta_option">
		<span class="lc_swp_before_option">
			<?php echo esc_html__('Remove footer widgets area for this page:', 'slide-music-core'); ?>
		</span>
		<input name="lc_swp_meta_page_remove_footer" type="checkbox" value="1" <?php checked("1", $remove_footer_widgets); ?>>
	</div>	
<?php
	$output = ob_get_clean();
	
	echo $output;
}

/*custom heading area*/
function SLIDE_SWP_custom_header_meta_callback($post) {
	$stored_meta = get_post_meta($post->ID);
	
	$page_subtitle = '';
	if (isset($stored_meta['lc_swp_meta_subtitle'])) {
		$page_subtitle = $stored_meta['lc_swp_meta_subtitle'][0];
	}
	
	$color_theme = 'settings_default';
	if (isset($stored_meta['lc_swp_meta_heading_color_theme'])) {
		$color_theme = $stored_meta['lc_swp_meta_heading_color_theme'][0];
	}
	$color_themes_support = array(
		'Default'			=> 'settings_default',
		'White On Black'	=> 'white_on_black',
		'Black On White'	=>	'black_on_white'
	);
	
	$show_page_title_as = 'title_centered';
	if (isset($stored_meta['lc_swp_meta_heading_full_color'])) {
		$show_page_title_as = $stored_meta['lc_swp_meta_heading_full_color'][0];
	}
	$show_page_title_support = array(
		'Title Centered'		=> 'title_centered',
		'Title Left'	=> 'title_left'
	);
	
	$header_bg_image = '';
	if (isset($stored_meta['lc_swp_meta_heading_bg_image'])) {
		$header_bg_image = $stored_meta['lc_swp_meta_heading_bg_image'][0];
	}
	
	$overlay_color = '';
	if (isset($stored_meta['lc_swp_meta_heading_overlay_color'])) {
		$overlay_color = $stored_meta['lc_swp_meta_heading_overlay_color'][0];
	}
	
	/*
		Menu Custom Colors - they do not apply for sticky menu
	*/
	/*custom logo image*/
	$page_logo = '';
	if (isset($stored_meta['lc_swp_meta_page_logo'])) {
		$page_logo = $stored_meta['lc_swp_meta_page_logo'][0];
	}

	/*menu bar bg color*/
	$page_menu_bg = '';
	if (isset($stored_meta['lc_swp_meta_page_menu_bg'])) {
		$page_menu_bg = $stored_meta['lc_swp_meta_page_menu_bg'][0];
	}

	/*menu bar txt color*/
	$page_menu_txt_color = '';
	if (isset($stored_meta['lc_swp_meta_page_menu_txt_color'])) {
		$page_menu_txt_color = $stored_meta['lc_swp_meta_page_menu_txt_color'][0];
	}			

	?>
	<h4 class="swp_text_align_center"> <?php echo esc_html__('Subtitle &amp; Text Color', 'slide-music-core'); ?> </h4>	
	<div class="heading_meta_option">
		<span class="lc_swp_before_option">
			<?php echo esc_html__('Page subtitle:', 'slide-music-core'); ?>
		</span>
		<input type="text" class="lc_swp_option" name="lc_swp_meta_subtitle" id="lc_swp_meta_subtitle" value="<?php echo esc_html($page_subtitle); ?>" />
	</div>

	<div class="heading_meta_option">
		<span class="lc_swp_before_option">
			<?php echo esc_html__('Color Scheme:', 'slide-music-core'); ?>
		</span>
		<select id="lc_swp_meta_heading_color_theme" name="lc_swp_meta_heading_color_theme">
		<?php
			foreach($color_themes_support as $key => $value) {
				if ($value == $color_theme) {
					?>
					<option value="<?php echo esc_attr($value); ?>" selected="selected"> <?php echo esc_html($key); ?> </option>
					<?php
				} else {
					?>
					<option value="<?php echo esc_attr($value); ?>"> <?php echo esc_html($key); ?> </option>
					<?php
				}
			}
		?>
		</select>
		<p class="description show_on_right">
			<?php echo esc_html__('Choose a color scheme for the heading area to overwrite the global settings in Appearance - Slide Settings.', 'slide-music-core'); ?>
		</p>		
	</div>
	
	<div class="heading_meta_option">
		<span class="lc_swp_before_option">
			<?php echo esc_html__('Heading style:', 'slide-music-core'); ?>
		</span>
		<select id="lc_swp_meta_heading_full_color" name="lc_swp_meta_heading_full_color">
		<?php
			foreach($show_page_title_support as $key => $value) {
				if ($value == $show_page_title_as) {
					?>
					<option value="<?php echo esc_attr($value); ?>" selected="selected"> <?php echo esc_html($key); ?> </option>
					<?php
				} else {
					?>
					<option value="<?php echo esc_attr($value); ?>"> <?php echo esc_html($key); ?> </option>
					<?php
				}
			}
		?>
		</select>
		<p class="description show_on_right">
			<?php echo esc_html__('If the subtitle is not present, heading style is ignored.', 'slide-music-core'); ?>
		</p>
	</div>

	<hr>
	<h4 class="swp_text_align_center"> <?php echo esc_html__('Header Background', 'slide-music-core'); ?> </h4>	
	<p class="meta_area_desc"><?php echo esc_html__('Choose a custom background image and color overlay for header', 'slide-music-core'); ?></p>	
	<div class="heading_meta_option">
		<input type="text" style="width:100%;" name="lc_swp_meta_heading_bg_image" id="lc_swp_meta_heading_bg_image" value="<?php echo esc_url($header_bg_image); ?>" />
		<div class="lc_swp_meta_head_bg_image_buttons">
			<span class="lc_swp_before_option">
				<?php echo esc_html__('Background image:', 'slide-music-core'); ?>
			</span>
			<input type="button" id="lc_swp_meta_head_bg_image-button" class="button" value="<?php echo esc_html__('Choose Image', 'slide-music-core'); ?>" />
			<input type="button" id="lc_swp_meta_head_bg_image-buttondelete" class="button" value="<?php echo esc_html__('Remove Image', 'slide-music-core'); ?>" />
		</div>
		
		<div id="custom_head_bg_meta_preview">
			<img style="max-width:100%;" src="<?php echo esc_url($header_bg_image); ?>" />
		</div>
	</div>
	
	<div class="heading_meta_option">
		<span class="lc_swp_before_option">
			<?php echo esc_html__('Background color overlay:', 'slide-music-core'); ?>
		</span>
		<div class="lc_swp_option_right">
			<input type="text" class="lc_swp_option alpha-color-picker" name="lc_swp_meta_heading_overlay_color" value="<?php echo esc_attr($overlay_color); ?>" data-default-color="rgba(0,0,0,0)" data-show-opacity="true" />
		</div>
	</div>
	<hr>

	<h4 class="swp_text_align_center"> <?php echo esc_html__('Custom Menu Colors &amp; Logo', 'slide-music-core'); ?> </h4>		
	<p class="meta_area_desc"><?php echo esc_html__('Add custom colors for the menu area only for this page/post', 'slide-music-core'); ?></p>
	<div class="heading_meta_option">
		<input type="text" style="width:100%;" name="lc_swp_meta_page_logo" id="lc_swp_meta_page_logo" value="<?php echo esc_url($page_logo); ?>" />
		<div class="lc_swp_meta_page_logo_image_buttons">
			<span class="lc_swp_before_option">
				<?php echo esc_html__('Custom logo image:', 'slide-music-core'); ?>
			</span>
			<input type="button" id="lc_swp_meta_page_logo_image-button" class="button" value="<?php echo esc_html__('Choose Custom Logo', 'slide-music-core'); ?>" />
			<input type="button" id="lc_swp_meta_page_logo-buttondelete" class="button" value="<?php echo esc_html__('Remove Custom Logo', 'slide-music-core'); ?>" />
		</div>
		
		<div id="custom_head_page_logo_meta_preview">
			<img style="max-width:100%;" src="<?php echo esc_url($page_logo); ?>" />
		</div>
		<p class="description"><?php echo esc_html__('Choose custom logo image. The logo will overwrite the default logo for this page.', 'slide-music-core'); ?></p>
	</div>	
	
	<div class="heading_meta_option">
		<span class="lc_swp_before_option">
			<?php echo esc_html__('Menu bar background color:', 'slide-music-core'); ?>
		</span>
		<div class="lc_swp_option_right">
			<input type="text" class="lc_swp_option alpha-color-picker" name="lc_swp_meta_page_menu_bg" value="<?php echo esc_attr($page_menu_bg); ?>" data-default-color="" data-show-opacity="true" />
			<p class="description"><?php echo esc_html__('Choose custom background color for the menu bar. This color will overwrite the default color for this page.', 'slide-music-core'); ?></p>
		</div>
	</div>

	<div class="heading_meta_option">
		<span class="lc_swp_before_option">
			<?php echo esc_html__('Menu bar text color:', 'slide-music-core'); ?>
		</span>
		<div class="lc_swp_option_right">
			<input type="text" class="lc_swp_option alpha-color-picker" name="lc_swp_meta_page_menu_txt_color" value="<?php echo esc_attr($page_menu_txt_color); ?>" data-default-color="" data-show-opacity="false" />
			<p class="description"><?php echo esc_html__('Choose custom text color for the menu bar. This color will overwrite the default color for this page.', 'slide-music-core'); ?></p>
		</div>
	</div>	
	<?php
}

/*
	Discography settings meta
*/
function SLIDE_SWP_discography_settings_cbk($post) {
	$stored_meta = get_post_meta($post->ID);

	$items_on_row = 3;
	if (isset($stored_meta['lc_swp_meta_disco_it_on_row'])) {
		$items_on_row = $stored_meta['lc_swp_meta_disco_it_on_row'][0];
	}

	$items_on_row_support = array(
		'3 - Default'	=> '3',
		'4'				=> '4',
		'5'				=> '5'
	);
?>
	<div class="blog_option heading_meta_option">
		<span class="lc_swp_before_option"><?php echo esc_html__("Albums On Row:", "slide-music-core"); ?></span>
		<select id="lc_swp_meta_disco_it_on_row" name="lc_swp_meta_disco_it_on_row">
		<?php
			foreach($items_on_row_support as $key => $value) {
				if ($value == $items_on_row) {
					?>
					<option value="<?php echo esc_attr($value); ?>" selected="selected"> <?php echo esc_html($key); ?> </option>
					<?php
				} else {
					?>
					<option value="<?php echo esc_attr($value); ?>"> <?php echo esc_html($key); ?> </option>
					<?php
				}
			}
		?>
		</select>
		<p class="description show_on_right">
			<?php echo esc_html__('Choose how many items on row are shown.', 'slide-music-core'); ?>
		</p>
	</div>
<?php	
}

/*
	Artist Selection
*/
function SLIDE_SWP_artist_select_meta_callback($post) {
	$stored_meta = get_post_meta($post->ID);

	$artist_selection = '';
	if (isset($stored_meta['swp_artist_selection'])) {
		$artist_selection = $stored_meta['swp_artist_selection'][0];
	}

	$artist_selection = explode(',', $artist_selection);

	$args = array(
			'numberposts'		=> 	-1,
			'orderby'          => 'post_date',
			'order'            => 'DESC',
			'post_type'        => 'js_artist',
			'post_status'      => 'publish'
		);

	$artist_posts = get_posts($args);

?>
	<div class="heading_meta_option">
		<span class="lc_swp_before_option"><?php echo esc_html__("Select one or more artists:", "slide-music-core"); ?></span>
		<select id="swp_artist_selection" name="swp_artist_selection[]" multiple>
		<?php
			foreach($artist_posts as $single_artist) {
				if (in_array($single_artist->ID, $artist_selection)) {
					?>
					<option value="<?php echo esc_attr($single_artist->ID); ?>" selected="selected"> <?php echo esc_html($single_artist->post_title); ?> </option>
					<?php
				} else {
					?>
					<option value="<?php echo esc_attr($single_artist->ID); ?>"> <?php echo esc_html($single_artist->post_title); ?> </option>
					<?php
				}
			}
		?>
		</select>
		<p class="description for_artist_selection show_on_right">
			<?php 
				echo esc_html__('Select artists for this event/video/album. Hold down the Ctrl (windows) or Command (Mac) button to select multiple options.', 'slide-music-core'); 
			?>
		</p>
	</div>
<?php
}

/*
	Show cpt categories on archive pages
*/
function SLIDE_SWP_show_cpt_cat_meta_callback($post) {
	$stored_meta = get_post_meta($post->ID);

	$show_cpt_cat = "no";
	if (isset($stored_meta['swp_show_cpt_cat'])) {
		$show_cpt_cat = $stored_meta['swp_show_cpt_cat'][0];
	}

	$show_cpt_cat_values = array(
		'Do not show'		=> 'no',
		'Show categories'	=> 'yes'
	);
?>
	<div class="blog_option heading_meta_option">
		<span class="lc_swp_before_option"><?php echo esc_html__("Show custom post type categories:", "slide-music-core"); ?></span>
		<select id="swp_show_cpt_cat" name="swp_show_cpt_cat">
		<?php
			foreach($show_cpt_cat_values as $key => $value) {
				if ($value == $show_cpt_cat) {
					?>
					<option value="<?php echo esc_attr($value); ?>" selected="selected"> <?php echo esc_html($key); ?> </option>
					<?php
				} else {
					?>
					<option value="<?php echo esc_attr($value); ?>"> <?php echo esc_html($key); ?> </option>
					<?php
				}
			}
		?>
		</select>
		<p class="description show_on_right">
			<?php echo esc_html__('Choose to show custom post categories under the page title.', 'slide-music-core'); ?>
		</p>
	</div>
<?php
}


/* 
|--------------------------------------------------------------------------
| SAVE META VALUES
|--------------------------------------------------------------------------
*/
function SLIDE_SWP_custom_bg_meta_save($post_id) {
     // Checks save status
    $is_autosave = wp_is_post_autosave( $post_id );
    $is_revision = wp_is_post_revision( $post_id );
    $is_valid_nonce = ( isset( $_POST[ 'js_swp_nonce' ] ) && wp_verify_nonce( $_POST[ 'js_swp_nonce' ], basename( __FILE__ ) ) ) ? 'true' : 'false';
 
    // Exits script depending on save status
    if ( $is_autosave || $is_revision || !$is_valid_nonce ) {
        return;
    }
 
	// Checks for input and saves if needed
	if( isset( $_POST[ 'js_swp_meta_bg_image' ] ) ) {
		update_post_meta( $post_id, 'js_swp_meta_bg_image', trim(esc_url($_POST['js_swp_meta_bg_image']))) ;
	}
	if( isset( $_POST[ 'lc_swp_meta_page_overlay_color' ] ) ) {
		update_post_meta( $post_id, 'lc_swp_meta_page_overlay_color', trim($_POST['lc_swp_meta_page_overlay_color'])) ;
	}
	if(isset($_POST['lc_swp_meta_page_color_theme'])) {
		update_post_meta($post_id, 'lc_swp_meta_page_color_theme', trim($_POST['lc_swp_meta_page_color_theme'])) ;
	}
	if(isset($_POST[ 'lc_swp_meta_page_remove_footer' ])) {
		update_post_meta( $post_id, 'lc_swp_meta_page_remove_footer', '1');
	} else {
		update_post_meta( $post_id, 'lc_swp_meta_page_remove_footer', '0');
	}
}
add_action('save_post', 'SLIDE_SWP_custom_bg_meta_save');

function SLIDE_SWP_custom_header_meta_save($post_id) {
    $is_autosave = wp_is_post_autosave( $post_id );
    $is_revision = wp_is_post_revision( $post_id );
	
	if ($is_autosave || $is_revision) {
		return;
	}
	
	if(isset($_POST['lc_swp_meta_subtitle'])) {
		update_post_meta($post_id, 'lc_swp_meta_subtitle', trim($_POST['lc_swp_meta_subtitle'])) ;
	}
	if(isset($_POST['lc_swp_meta_heading_color_theme'])) {
		update_post_meta($post_id, 'lc_swp_meta_heading_color_theme', trim($_POST['lc_swp_meta_heading_color_theme'])) ;
	}
	if(isset($_POST['lc_swp_meta_heading_full_color'])) {
		update_post_meta($post_id, 'lc_swp_meta_heading_full_color', trim($_POST['lc_swp_meta_heading_full_color'])) ;
	}
	if(isset($_POST['lc_swp_meta_heading_bg_image'])) {
		update_post_meta($post_id, 'lc_swp_meta_heading_bg_image', trim(esc_url($_POST['lc_swp_meta_heading_bg_image']))) ;
	}
	if(isset($_POST['lc_swp_meta_heading_overlay_color'])) {
		update_post_meta($post_id, 'lc_swp_meta_heading_overlay_color', trim($_POST['lc_swp_meta_heading_overlay_color'])) ;
	}

	/*
		Save Custom Page Related MENU Colors
	*/
	if(isset($_POST['lc_swp_meta_page_logo'])) {
		update_post_meta($post_id, 'lc_swp_meta_page_logo', trim($_POST['lc_swp_meta_page_logo'])) ;
	}
	if(isset($_POST['lc_swp_meta_page_menu_bg'])) {
		update_post_meta($post_id, 'lc_swp_meta_page_menu_bg', trim($_POST['lc_swp_meta_page_menu_bg'])) ;
	}
	if(isset($_POST['lc_swp_meta_page_menu_txt_color'])) {
		update_post_meta($post_id, 'lc_swp_meta_page_menu_txt_color', trim($_POST['lc_swp_meta_page_menu_txt_color'])) ;
	}	
}
add_action('save_post', 'SLIDE_SWP_custom_header_meta_save');

function SLIDE_SWP_disco_settings_meta_save($post_id) {
	$is_autosave = wp_is_post_autosave( $post_id );
    $is_revision = wp_is_post_revision( $post_id );
	
	if ($is_autosave || $is_revision) {
		return;
	}
	
	if(isset($_POST['lc_swp_meta_disco_it_on_row'])) {
		update_post_meta($post_id, 'lc_swp_meta_disco_it_on_row', trim($_POST['lc_swp_meta_disco_it_on_row'])) ;
	} else {
		update_post_meta($post_id, 'lc_swp_meta_disco_it_on_row', '3') ;
	}
}
add_action('save_post', 'SLIDE_SWP_disco_settings_meta_save');

function SLIDE_SWP_custom_post_cat_save($post_id) {
	$is_autosave = wp_is_post_autosave( $post_id );
    $is_revision = wp_is_post_revision( $post_id );
	
	if ($is_autosave || $is_revision) {
		return;
	}
	
	if(isset($_POST['swp_show_cpt_cat'])) {
		update_post_meta($post_id, 'swp_show_cpt_cat', trim($_POST['swp_show_cpt_cat'])) ;
	} else {
		update_post_meta($post_id, 'swp_show_cpt_cat', 'no') ;
	}
}
add_action('save_post', 'SLIDE_SWP_custom_post_cat_save');

function SLIDE_SWP_artist_selection_save($post_id) {
	$is_autosave = wp_is_post_autosave( $post_id );
    $is_revision = wp_is_post_revision( $post_id );
	
	if ($is_autosave || $is_revision) {
		return;
	}

	$new = isset ($_POST['swp_artist_selection'] )  ? $_POST['swp_artist_selection'] : array();
	$val_to_save =  empty($new) ? "" : implode(",", $new);
	
	update_post_meta($post_id, 'swp_artist_selection', $val_to_save) ;
}
add_action('save_post', 'SLIDE_SWP_artist_selection_save');

/* 
|--------------------------------------------------------------------------
| ENQUEUE JS SCRIPTS
| js_swp_custom_bg_meta.JS - opens media gallery
|--------------------------------------------------------------------------
*/
function SLIDE_SWP_custom_bg_script() {
    global $typenow;
    if (($typenow == 'page') || ($typenow == 'post') || 
	($typenow == 'js_videos') || ($typenow == 'js_photo_albums') || ($typenow == 'js_events') || ($typenow == 'js_albums') ||
	($typenow == 'js_artist')) {
        wp_enqueue_media();
 
        wp_register_script( 'js_swp_custom_bg_meta', CDIR_URL . '/js/js_swp_custom_bg_meta.js', array( 'jquery', 'alpha_color_picker'), null, true);
        wp_enqueue_script( 'js_swp_custom_bg_meta' );
    }
}
add_action('admin_enqueue_scripts', 'SLIDE_SWP_custom_bg_script');