<?php

/*
	MailChimb Newsletter Form Processing
*/
add_action('wp_ajax_swpmcform_action', 'SLIDE_SWP_process_mailchimp_subscr_form');
add_action('wp_ajax_nopriv_swpmcform_action', 'SLIDE_SWP_process_mailchimp_subscr_form');

if (!function_exists('SLIDE_SWP_process_mailchimp_subscr_form')) {
	function SLIDE_SWP_process_mailchimp_subscr_form() {
		
		$data = array();
		parse_str($_POST['data'], $data);

		$namedError = '';
		$ret['success'] = false;
		
		$list_id = SMC_get_mailchimp_list_id();
		$api_key = SMC_get_mailchimp_key();

		if (!strlen($list_id) || !strlen($api_key)) {
			$ret['success'] = false;
			$ret['error'] = esc_html__('A problem occurred, could not register your email.', 'slide-music-core');
			echo json_encode($ret);
			die();
		}

		if(isset($data['subscrform_nonce']) && wp_verify_nonce($data['subscrform_nonce'], 'swpmcform_action')) {

			require_once(CDIR_PATH."/assets/mailchimp/MailChimp.php");
			$MailChimp = new MailChimp($api_key);
			
			$mc_merge_fields = array(
				'FNAME'=> '', 
				'LNAME'=> ''
				);
			$mc_opts = array(
					'email_address' => $data["newsletter_email"],
	                'merge_fields'  => $mc_merge_fields,
	                'status'        => 'subscribed'
				);
			$result = $MailChimp->post("lists/$list_id/members", $mc_opts);

			if ($MailChimp->success()) {
				$ret['success'] = true;
			} else {
				$namedError = $MailChimp->getLastError();
			}
		} else {
			$namedError = esc_html__('Please refresh the page and try again.', 'artemis-swp-core');
		}

		$ret['error'] = $namedError;
		echo json_encode($ret);	

		die();
	}
}

/*
	Contact Form Processing
*/
add_action('wp_ajax_swpcontactform_action', 'SLIDE_SWP_process_contact_form');
add_action('wp_ajax_nopriv_swpcontactform_action', 'SLIDE_SWP_process_contact_form');

if (!function_exists('SLIDE_SWP_process_contact_form')) {
	function SLIDE_SWP_process_contact_form() {
		$data = array();
		parse_str($_POST['data'], $data);
		$namedError = '';
		$ret['success'] = false;


		
		if(isset($data['contactform_nonce']) && wp_verify_nonce($data['contactform_nonce'], 'swpcontactform_action')) {
			if (sanitize_text_field($data['contactName']) === '') {
				$hasError = true;
				$namedError = esc_html__('Please eneter a valid name', 'slide');
			} else {
				$name = sanitize_text_field($data['contactName']);
			}

			if (trim($data['email']) === '') {
				$hasError = true;
				$namedError = esc_html__('Your email address cannot be empty', 'slide');
			}
			else {
				if ((!is_email($data['email']))) {
					$hasError = true;
					$namedError = esc_html__('Email address is not correct, please enter a valid email address', 'slide');
				} 
				else {
					$email = trim($data['email']);
				}
			}
			
			if(sanitize_text_field($data['comments']) === '') {
				$hasError = true;
				$namedError = esc_html__('Please enter a message.', 'slide');;
			}
			else {
				$comments = sanitize_text_field($data['comments']);
			}

			if(!isset($hasError)) {
				$emailTo = SLIDE_SWP_LMC_get_contact_form_email();

				$email_subject = esc_html__("New contact form message from your website ", 'slide')."[" . get_bloginfo('name') . "] ";
				$email_message = $comments;
				$email_message .= "\n\n".esc_html__("Sender Email: ", 'slide')." ".$email."\n";
				$email_message .= "\n\n".esc_html__("Sender Name: ", 'slide')." ".$name."\n";
				
				/* e-mail headers with the user's name, e-mail address and character encoding*/
				$headers = "MIME-Version: 1.0\r\n" .
				"Content-Type: text/plain; charset=\"" . get_option('blog_charset') . "\"\r\n";		

				if (!wp_mail($emailTo, $email_subject, $email_message, $headers)) {
					$namedError = 'wp_mail_failed';
				} else {
					$ret['success'] = true;	
				}
			} 
		} else {
			$namedError = 'nonce';
		}
		
		$ret['error'] = $namedError;
		echo json_encode($ret);	
		
		die();
	}
}
