
jQuery(document).ready(function($) {
	'use strict';

	ajaxCF($);
	handleMCSubscription($);
});

var ajaxCF = function($) {
	if (!$('form.swp_contactform').length) {
		return;
	}

	$("form.swp_contactform").submit(function(event) {
		event.preventDefault();

		$("form.swp_contactform").find(".form_result_error").val('');
		$("form.swp_contactform").find(".form_result_error").hide();
		
		var name = $.trim($(this).find("input#contactName").val());
		var email = $.trim($(this).find("input#contactemail").val());
		var message = $.trim($(this).find("textarea#commentsText").val());
		var required_is_empty = false;

		if ('' == name) {
			required_is_empty = true;
			$(this).find('.comment-form-author').find('.swp_cf_error').show('slow');
		}

		if ('' == email) {
			required_is_empty = true;
			$(this).find('.comment-form-email').find('.swp_cf_error').show('slow');
		}

		if ('' == message) {
			required_is_empty = true;
			$(this).find('.comment-form-comment').find('.swp_cf_error').show('slow');
		}

		if (required_is_empty) {
			return;
		}

		var data = {
			action: 'swpcontactform_action',
			data: $(this).find(":input").serialize()
		};

		var $button = $(this).find(".lc_button.contact_button");
		var old_button_val = $button.val();
		$button.val($button.data('loadingmsg'));

		$.post(DATAVALUES.ajaxurl, data, function(response) {
			var obj;
			
			try {
				obj = $.parseJSON(response);
			}
			catch(e) {
				$button.val(old_button_val);
				$("form.swp_contactform").find(".form_result_error").append(obj.error);
				$("form.swp_contactform").find(".form_result_error").show('slow');
				return;
			}

			if(obj.success === true) {
				$("form.swp_contactform").find(".formResultOK").find(".swp_cf_error").show("slow");

				$("form.swp_contactform").find("input#contactName").val('');
				$("form.swp_contactform").find("input#contactemail").val('');
				$("form.swp_contactform").find("textarea#commentsText").val('');
			} else {

				if (obj.error === 'wp_mail_failed') {
					$("form.swp_contactform").find(".wp_mail_error").find(".swp_cf_error").show("slow");
				} else {
					$("form.swp_contactform").find(".form_result_error").append(obj.error);
					$("form.swp_contactform").find(".form_result_error").show('slow');
				}
			}
			$button.val(old_button_val);
		});		

	});
}

function handleMCSubscription($) {
	$('.swp_mc_subscr_container').each(function(){
		var $container = $(this);
		var $button = $(this).find('.at_news_button_entry');

		$(this).find('form.swp_mc_subscr_form').submit(function(event) {
			event.preventDefault();
			$button.val($button.data('loadingmsg'));
			$container.find('.swp_mc_form_error').empty();
			$container.find('.swp_mc_form_error').hide();

			var data = {
				action: 'swpmcform_action',
				data: $(this).find(":input").serialize()
			};

			$.post(DATAVALUES.ajaxurl, data, function(response) {
				var obj;
				
				try {
					obj = $.parseJSON(response);
				}
				catch(e) {
					$container.find('.swp_mc_form_error').append(DATAVALUES.generalErrorText);
					$button.val($button.data('btnval'));
					return;
				}

				if(obj.success === true) {
					$container.find('.swp_mc_form_success').show('slow');
					$container.find('input').each(function(){
						$(this).val('');
					})
				} else {
					$container.find('.swp_mc_form_error').append(obj.error);
					$container.find('.swp_mc_form_error').show('slow');
					
				}
				$button.val($button.data('btnval'));
			});			

		});
	});
}