<?php

/*
	Create menu entry
*/
function SLIDE_SWP_SMC_menu_entry() {    
	add_options_page("Slide Music Core Settings", "Slide Music Core Settings", "manage_options", "Slide-Post-Types-Settings", "SLIDE_SWP_LMC_output_content");
}
add_action('admin_menu', 'SLIDE_SWP_SMC_menu_entry');


/*add plugin settings to admin bar*/
function SLIDE_SWP_add_SMC_settings_to_adminbar($admin_bar) {
	$admin_bar->add_menu( 
		array(
        'id'    => 'slide-core-settings',
        'title' => esc_html__("Slide Core Settings", "slide-music-core"),
        'href'  => admin_url( 'options-general.php?page=Slide-Post-Types-Settings'),
        'meta'  => array(
            'title' => esc_html__("Go To Slide Music Core Settings", "slide-music-core")
        	)
    	)
	);
}
add_action('admin_bar_menu', 'SLIDE_SWP_add_SMC_settings_to_adminbar', 9999);

/*
	Callback renders options content
*/
function SLIDE_SWP_LMC_output_content() {
?> 
	<!-- Create a header in the default WordPress 'wrap' container -->      
	<div class="wrap">
		<!-- Add the icon to the page -->          
		<h2><?php echo esc_html__("Slide Music Core Plugin Settings", "slide-music-core"); ?></h2>
		
		<!-- Make a call to the WordPress function for rendering errors when settings are saved. -->          
		<?php settings_errors(); ?> 				       
		
		<!-- Create the form that will be used to render our options -->
		<form method="post" action="options.php"> 			
			<?php   			
			settings_fields( 'SMC_plugin_options' );  		
			do_settings_sections( 'SMC_plugin_options' );						
			submit_button(); 			
			?>        
		</form>  
	
	</div>
 <?php
	/* very important call*/
	flush_rewrite_rules();
 }
 
 add_action('admin_init', 'SLIDE_SWP_LMC_initialize_lmc_options');
 
 function SLIDE_SWP_LMC_initialize_lmc_options()  {	
	/* 
		Create plugin options 
	*/
	if( false == get_option( 'SMC_plugin_options')) {		
		add_option( 'SMC_plugin_options' );	
	}
	 
	/* 
		Create settings section	
	*/
	 add_settings_section(  		
		 'LMC_plugin_section',          	/* ID used to identify this section and with which to register options  */		
		 esc_html__('Slide Plugin Settings', 'slide-music-core'),                   /* Title to be displayed on the administration page   */		
		 'SMC_plugin_options_callback',  	/* Callback used to render the description of the section */		
		 'SMC_plugin_options'      			/* Page on which to add this section of options  */	
	 );	
	 
	register_setting(  
		'SMC_plugin_options',  		//option group - A settings group name. Must exist prior to the register_setting call. This must match the group name in settings_fields()
		'SMC_plugin_options',  		// option_name -  The name of an option to sanitize and save. 
		'LMC_sanitize_plugin_options'  	//  $sanitize_callback (callback) (optional) A callback function that sanitizes the option's value
	);	

 	 
	/*
		Settings fields
	*/
	 add_settings_field(           
		 'events_slug',          								/* ID used to identify the field throughout the theme                */      
		 esc_html__('Event Post Type Slug', 'slide-music-core'),                				/* The label to the left of the option interface element   */             
		 'SMC_plugin_options_event_slug_callback', 				/* The name of the function responsible for rendering the option interface */     
		 'SMC_plugin_options',   								/* The page on which this option will be displayed   */      
		 'LMC_plugin_section'    								/* The name of the section to which this field belongs   */    
	 ); 

	 add_settings_field(           
		 'photo_albums_slug',
		 esc_html__('Photo Album Post Type Slug', 'slide-music-core'),
		 'SMC_plugin_options_photo_album_slug_callback',
		 'SMC_plugin_options',
		 'LMC_plugin_section'
	 ); 

	 add_settings_field(           
		 'videos_slug',
		 esc_html__('Video Post Type Slug', 'slide-music-core'),
		 'SMC_plugin_options_video_slug_callback',
		 'SMC_plugin_options',
		 'LMC_plugin_section'
	 ); 

	 add_settings_field(           
		 'albums_slug',
		 esc_html__('Audio Post Type Slug', 'slide-music-core'),
		 'SMC_plugin_options_album_slug_callback',
		 'SMC_plugin_options',
		 'LMC_plugin_section'
	 );
	add_settings_field(           
		 'artist_slug',
		 esc_html__('Artist Post Type Slug', 'slide-music-core'),
		 'SMC_plugin_options_artist_slug_callback',
		 'SMC_plugin_options',
		 'LMC_plugin_section'
	 );	

	/*
		Custom Post Types TAXONOMY slug
	*/
	add_settings_field(           
		'events_tax_slug',
		esc_html__('Event Category Slug', 'slide-music-core'),
		'SMC_plugin_options_event_tax_slug_callback',
		'SMC_plugin_options',
		'LMC_plugin_section'
	);
	
	add_settings_field(           
		'photo_albums_tax_slug',
		esc_html__('Photo Album Category Slug', 'slide-music-core'),
		'SMC_plugin_options_photo_album_tax_slug_callback',
		'SMC_plugin_options',
		'LMC_plugin_section'
	);
	
	add_settings_field(           
		'video_tax_slug',
		esc_html__('Video Category Slug', 'slide-music-core'),
		'SMC_plugin_options_video_tax_slug_callback',
		'SMC_plugin_options',
		'LMC_plugin_section'
	);

	add_settings_field(           
		'album_tax_slug',
		esc_html__('Album Category Slug', 'slide-music-core'),
		'SMC_plugin_options_album_tax_slug_callback',
		'SMC_plugin_options',
		'LMC_plugin_section'
	);

	add_settings_field(           
		'artist_tax_slug',
		esc_html__('Artist Category Slug', 'slide-music-core'),
		'SMC_plugin_options_artist_tax_slug_callback',
		'SMC_plugin_options',
		'LMC_plugin_section'
	);

	/*
		Contact Form Email
	*/
	add_settings_field(           
		'lc_mc_contact_form_email',
		esc_html__('Contact Form E-mail', 'slide-music-core'),
		'SMC_plugin_options_contact_form_email_callback',
		'SMC_plugin_options',
		'LMC_plugin_section'
	);

	add_settings_field(           
		'swp_mailchimp_key',
		esc_html__('MailChimp Api KEY', 'slide-music-core'),
		'SMC_plugin_options_swp_mailchimp_key_callback',
		'SMC_plugin_options',
		'LMC_plugin_section'
	);
	add_settings_field(           
		'swp_mailchimp_list_id',
		esc_html__('MailChimp List ID', 'slide-music-core'),
		'SMC_plugin_options_swp_mailchimp_list_id_callback',
		'SMC_plugin_options',
		'LMC_plugin_section'
	);
	add_settings_field(           
		'swp_hide_sharing_icons',
		esc_html__('Hide sharing icons', 'slide-music-core'),
		'SMC_plugin_options_hide_sharing_icons_cbk',
		'SMC_plugin_options',
		'LMC_plugin_section'
	);	

 }


 
 
 /* 
|--------------------------------------------------------------------------
| CALLBACK FUNCTIONS
|--------------------------------------------------------------------------
*/
function SMC_plugin_options_callback() {
	echo esc_html__('Set up the slugs for custom post types and the contact form recipiend email address.', 'slide-music-core');
}
 
function SMC_plugin_options_event_slug_callback() {
	$options = get_option('SMC_plugin_options');  
	  
	$slug = ''; 
	if( isset($options['event'])) { 
		$slug = $options['event']; 
	}
	 
	echo '<input type="text" size="50 id="event" name="SMC_plugin_options[event]" value="' . esc_attr($slug) . '" />';  	
}
 
function SMC_plugin_options_photo_album_slug_callback() {
	$options = get_option( 'SMC_plugin_options' );  
	  
	$slug = ''; 
	if( isset( $options['photo_album'])) { 
		$slug = esc_html($options['photo_album']); 
	}
	 
	echo '<input type="text" size="50 id="photo_album" name="SMC_plugin_options[photo_album]" value="' . esc_attr($slug) . '" />';
}
 
function SMC_plugin_options_video_slug_callback() {
	$options = get_option('SMC_plugin_options');  
	  
	$slug = ''; 
	if(isset($options['video'])) { 
		$slug = esc_html($options['video']); 
	}
	 
	echo '<input type="text" size="50 id="video" name="SMC_plugin_options[video]" value="' . esc_attr($slug) . '" />';  		
}
 
function SMC_plugin_options_album_slug_callback() {
	$options = get_option( 'SMC_plugin_options' );  
	  
	$slug = ''; 
	if(isset($options['album'])) { 
		$slug = esc_html($options['album']); 
	}
	 
	echo '<input type="text" size="50 id="album" name="SMC_plugin_options[album]" value="' . esc_attr($slug) . '" />';  		
}

function SMC_plugin_options_artist_slug_callback() {
	$options = get_option( 'SMC_plugin_options' );  
	  
	$slug = ''; 
	if(isset($options['artist'])) { 
		$slug = esc_html($options['artist']); 
	}
	 
	echo '<input type="text" size="50 id="artist" name="SMC_plugin_options[artist]" value="' . esc_attr($slug) . '" />';  
}

function SMC_plugin_options_event_tax_slug_callback() {
	$options = get_option( 'SMC_plugin_options' );
	
	$slug = ''; 
	if( isset( $options['event_tax'])) { 
		$slug = esc_html($options['event_tax']); 
	}
	
	echo '<input type="text" size="50 id="event_tax" name="SMC_plugin_options[event_tax]" value="' . esc_attr($slug) . '" />';  			
}

function SMC_plugin_options_photo_album_tax_slug_callback() {
	$options = get_option( 'SMC_plugin_options' );
	
	$slug = ''; 
	if(isset($options['photo_album_tax'])) { 
		$slug = esc_html($options['photo_album_tax']); 
	}
	
	echo '<input type="text" size="50 id="photo_album_tax" name="SMC_plugin_options[photo_album_tax]" value="' . esc_attr($slug) . '" />';  			
}

function SMC_plugin_options_video_tax_slug_callback() {
	$options = get_option('SMC_plugin_options');
	
	$slug = ''; 
	if( isset( $options['video_tax'])) { 
		$slug = esc_html($options['video_tax']); 
	}
	
	echo '<input type="text" size="50 id="video_tax" name="SMC_plugin_options[video_tax]" value="' . esc_attr($slug) . '" />'; 
}

function SMC_plugin_options_album_tax_slug_callback() {
	$options = get_option( 'SMC_plugin_options' );
	
	$slug = ''; 
	if(isset( $options['album_tax'])) { 
		$slug = esc_html($options['album_tax']); 
	}
	
	echo '<input type="text" size="50 id="album_tax" name="SMC_plugin_options[album_tax]" value="' . esc_attr($slug) . '" />'; 	
}

function SMC_plugin_options_artist_tax_slug_callback() {
	$options = get_option( 'SMC_plugin_options' );
	
	$slug = ''; 
	if(isset( $options['artist_tax'])) { 
		$slug = esc_html($options['artist_tax']); 
	}
	
	echo '<input type="text" size="50 id="artist_tax" name="SMC_plugin_options[artist_tax]" value="' . esc_attr($slug) . '" />'; 	
}

function SMC_plugin_options_contact_form_email_callback() {
	$options = get_option('SMC_plugin_options');

	$contact_form_email = '';
	if(isset( $options['lc_mc_contact_form_email'])) { 
		$contact_form_email = sanitize_email($options['lc_mc_contact_form_email']);
	}
?>
	<input type="text" size="50" id="SMC_plugin_options" name="SMC_plugin_options[lc_mc_contact_form_email]" value="<?php echo esc_html($contact_form_email); ?>"  class="swp_new_settings_section"/>
	<p class="description">
		<?php
		echo esc_html__("This is the recipient email address for the contact form.", "slide-music-core");
		?>
	</p>
<?php	
}

function SMC_plugin_options_swp_mailchimp_key_callback () {
	$options = get_option('SMC_plugin_options');

	$mc_api_key = '';
	if(isset( $options['swp_mailchimp_key'])) { 
		$mc_api_key = esc_html($options['swp_mailchimp_key']);
	}
?>
	<input type="text" size="50" id="SMC_plugin_options" name="SMC_plugin_options[swp_mailchimp_key]" value="<?php echo esc_html($mc_api_key); ?>" class="swp_new_settings_section"/>
	<p class="description">
		<?php
		echo esc_html__("MailChimp integration - MailChimp Api Key - will be used by the visual composer newsletter form.", "slide-music-core");
		?>
	</p>
<?php	
}

function SMC_plugin_options_swp_mailchimp_list_id_callback() {
	$options = get_option('SMC_plugin_options');

	$mc_list_id = '';
	if(isset( $options['swp_mailchimp_list_id'])) { 
		$mc_list_id = esc_html($options['swp_mailchimp_list_id']);
	}
?>
	<input type="text" size="50" id="SMC_plugin_options" name="SMC_plugin_options[swp_mailchimp_list_id]" value="<?php echo esc_html($mc_list_id); ?>" />
	<p class="description">
		<?php
		echo esc_html__("MailChimp integration - MailChimp List ID - will be used by the visual composer newsletter form.", "slide-music-core");
		?>
	</p>
<?php	
}

function SMC_plugin_options_hide_sharing_icons_cbk() {
	$options = get_option('SMC_plugin_options');

	$hide_sharing_icons = "";
	if(isset($options['swp_hide_sharing_icons'])) { 
		$hide_sharing_icons = esc_html($options['swp_hide_sharing_icons']);
	}
	if (empty($hide_sharing_icons)) {
		$hide_sharing_icons = 'disabled';
	}

	$show_sharing_options = array(
		esc_html__('Disabled - Show Icons', 'slide-music-core')	=> 'disabled',
		esc_html__('Enabled - Hide Icons', 'slide-music-core')	=> 'enabled'
	);
	?>

	<select id="swp_hide_sharing_icons" name="SMC_plugin_options[swp_hide_sharing_icons]" class="swp_new_settings_section">
		<?php foreach($show_sharing_options as $key => $value) {
			if ($value == $hide_sharing_icons) {
				?>
				<option value="<?php echo esc_attr($value); ?>" selected="selected"> <?php echo esc_attr($key); ?> </option>
				<?php
			} else {
				?>
				<option value="<?php echo esc_attr($value); ?>"> <?php echo esc_attr($key); ?> </option>
				<?php
			}
		} ?>
	</select>

	<p class="description">
		<?php echo esc_html__('Hide sharing icons at the end of the page/post.', 'slide-music-core'); ?>
	</p>

<?php	
}


/* 
|--------------------------------------------------------------------------
| SANITIZE CALLBACK
|--------------------------------------------------------------------------
*/
function LMC_sanitize_plugin_options($inputOptions) {
	// Define the array for the updated options  
	$output = array();  

	// Loop through each of the options sanitizing the data  
	foreach($inputOptions as $key => $val) {  
		if(isset($inputOptions[$key])) {
			if ("lc_mc_contact_form_email" == $key) {
				$output[$key] = sanitize_email(trim($inputOptions[$key]));
			} else {
				$output[$key] = esc_html(trim($inputOptions[$key]));  	
			}
			
		}
	}
	  
	// Return the new collection  
	return apply_filters('LMC_sanitize_plugin_options', $output, $inputOptions);
}

function SMC_get_mailchimp_key() {
	$options = get_option('SMC_plugin_options');

	if(isset( $options['swp_mailchimp_key'])) { 
		return esc_html($options['swp_mailchimp_key']);
	}

	return "";
}

function SMC_get_mailchimp_list_id() {
	$options = get_option('SMC_plugin_options');

	if(isset( $options['swp_mailchimp_list_id'])) { 
		return esc_html($options['swp_mailchimp_list_id']);
	}

	return "";
}

function SLIDE_SWP_show_sharing_icons_by_setting() {
	$options = get_option('SMC_plugin_options');

	if(isset( $options['swp_hide_sharing_icons'])) { 
		$hide_sharing_icons = esc_html($options['swp_hide_sharing_icons']);
	} 
	
	if (empty($hide_sharing_icons)) {
		return true;
	}	

	return "enabled" == $hide_sharing_icons ? false : true;
}

function SLIDE_SWP_is_sharing_visible() {
	/*always disable sharing for some pages*/
	if (function_exists("is_checkout")) {
		if (is_checkout() || is_cart()) {
			return false;
		}
	}

	return SLIDE_SWP_show_sharing_icons_by_setting();
}

?>