<?php

/*
	Load needed js scripts and css styles
*/
if (!function_exists('SLIDE_SWP_load_scripts_and_styles')) {
	function SLIDE_SWP_load_scripts_and_styles() {

		/*color scheme - page specific/settings default*/
		$scheme_file_name = SLIDE_SWP_get_specific_color_scheme();
		$scheme_file_name .= ".css";
		wp_enqueue_style('slide-swp-color-scheme', get_template_directory_uri(). '/core/css/'.$scheme_file_name);

		/*menu css*/
		$menu_style = SLIDE_SWP_get_menu_style();
		wp_enqueue_style('slide-swp-menu', get_template_directory_uri(). '/core/css/menu/'.$menu_style.'.css');

		/*main js file*/
		wp_enqueue_script('slide-swp', get_template_directory_uri().'/core/js/slide_swp.js', array('jquery', 'masonry', 'debouncedresize', 'unslider', 'justified-gallery'), '', true);

		/*lightbox*/
		wp_enqueue_script('lightbox', get_template_directory_uri().'/assets/lightbox2/js/lightbox.js', array('jquery'), '', true);
		wp_enqueue_style('lightbox', get_template_directory_uri(). '/assets/lightbox2/css/lightbox.css');

		/*masonry*/
		wp_enqueue_script('masonry');
		wp_enqueue_script('imagesloaded');

		/*font awesome*/
		wp_enqueue_style('font-awesome-5.0.8', get_template_directory_uri(). '/assets/font-awesome-5.0.8/css/font-awesome.min.css', array(), '5.0.8', 'all');

		/*hunter river signature font*/
		wp_enqueue_style('hunter-river-font', get_template_directory_uri(). '/assets/hunter-river-font/css/hunter-river.css');
		/*coco bold condensed font*/
		wp_enqueue_style('coco-font', get_template_directory_uri(). '/assets/coco-font/css/coco-font.css');

		/*linear icons free*/
		wp_enqueue_style('linearicons', get_template_directory_uri(). '/assets/linearicons/linear_style.css');

		/*debounce resize*/
		wp_enqueue_script('debouncedresize', get_template_directory_uri().'/core/js/jquery.debouncedresize.js', array('jquery'), '', true);

		/*justified gallery*/
		wp_enqueue_script('justified-gallery', get_template_directory_uri().'/assets/justifiedGallery/js/jquery.justifiedGallery.min.js', array('jquery'), '', true);
		wp_enqueue_style('justified-gallery', get_template_directory_uri(). '/assets/justifiedGallery/css/justifiedGallery.min.css');

		/*unslider*/
		wp_enqueue_script('unslider', get_template_directory_uri().'/assets/unslider/unslider-min.js', array('jquery'), '', true);
		wp_enqueue_style('unslider', get_template_directory_uri(). '/assets/unslider/unslider.css');

		if (is_singular() && comments_open() && get_option('thread_comments')) {
			wp_enqueue_script('comment-reply');
		}		
	}
}
add_action('wp_enqueue_scripts', 'SLIDE_SWP_load_scripts_and_styles');


if (!function_exists('SLIDE_SWP_load_admin_scripts_and_styles')) {
	function SLIDE_SWP_load_admin_scripts_and_styles() {
		wp_enqueue_media();

		/*alpha color picker*/
		wp_enqueue_script('alpha-color-picker',  get_template_directory_uri().'/core/js/alpha-color-picker.js', array('jquery', 'wp-color-picker'), '', true);
		wp_enqueue_style('alpha-color-picker', get_template_directory_uri(). '/core/css/alpha-color-picker.css', array('wp-color-picker'));

		/* theme settings*/
		wp_enqueue_script('slide-swp-theme-settings',  get_template_directory_uri().'/settings/js/theme_settings.js', array('jquery', 'alpha-color-picker'), '', true);
		wp_enqueue_style('slide-swp-theme-settings', get_template_directory_uri(). '/settings/css/theme_settings.css', array('alpha-color-picker'));
	}
}
add_action('admin_enqueue_scripts', 'SLIDE_SWP_load_admin_scripts_and_styles');

?>