jQuery(document).ready(function($) {
	'use strict';

	swpGlobalActions($);
	handleHmbMenu($);
	handleQuotes($);
	runMasonryForBlog($);	
	setContentHeight($);
	handleCoverBgImage($);
	handleBgColorAndJsStyle($);
	stickyMenu($);
	customPageMenuStyle($);
	handleVideoImageContainer($);
	handleAlbumImageContainer($);
	handleArtistTemplateSingles($);
	runMasonryGallery($);
	hanldeJsLinks($);
	logoInTheMiddle($);
	handleAsideMenu($);
	customAspectRatio($);
	handleVideoSection($);
	runUnslider($);
	swpMusicPlayer($);
	handleCountdown($);
	justifiedGallery($);

	$(window).scroll(function() {
		stickyMenu($);
		customPageMenuStyle($);
    });

	$(window).on("debouncedresize", function(event) {
		runMasonryForBlog($);
		handleVideoImageContainer($);
		handleAlbumImageContainer($);
		handleArtistTemplateSingles($);
		runMasonryGallery($);
		setContentHeight($);
		customAspectRatio($);
	});    
});

function swpGlobalActions($) {
	$('nav.classic_menu ul.menu li').hover(
		function() {
			$(this).find('> ul').addClass("swp_show_submenu");
		}, function() {
			$(this).find('> ul').removeClass("swp_show_submenu");
		}
	);
}

function handleHmbMenu($) {
	$('.hmb_menu').click(function() {
		$(this).find('.hmb_line').toggleClass('click');

		if ($(this).hasClass('hmb_mobile')) {
			if ($('header').hasClass('sticky_enabled')) {
				$("body").animate({ scrollTop: 0 }, 400, function(){
						showMobileMenuContainer($);
				});
			} else {
				showMobileMenuContainer($);
			}
		}		
	});

	$('nav.mobile_navigation').find('ul li.menu-item-has-children > a').click(function(event){
		var links_to = $(this).attr("href");
		var elt_fin = $(this).offset().left + $(this).width() + parseInt($(this).css("padding-right")) + parseInt($(this).css("padding-left"));
		var AFTER_WIDTH = 250;

		if ((event.offsetX > elt_fin - AFTER_WIDTH) ||
			("#" == links_to)) {
			event.preventDefault();
			$(this).parent().find('> ul').toggle('300');
		}
	});
	/*close menu on anchor links*/
	$('nav.mobile_navigation').find("a").click(function(){
		var links_to = $(this).attr("href");
		if ((links_to.indexOf("#") > -1) && (("#" != links_to))) { 
			$('.hmb_menu').trigger("click");
		}
	});	
}

function showMobileMenuContainer($) {
	$('.mobile_navigation_container').toggle();
	$('.mobile_navigation_container').toggleClass('mobile_menu_opened');	
}

function handleQuotes($) {
	$('blockquote').each(function(){
		$(this).prepend($('<i class="fas fa-quote-left" aria-hidden="true"></i>'));
	});
}

function setContentHeight($) {

	if (!$('#lc_swp_content').length) {
		return;
	}

	$('#lc_swp_content').css("min-height", "");

	var totalHeight = $(window).height();
	if ($('#heading_area').length > 0) {
		totalHeight -= $('#heading_area').height();
	}
	if ($('#footer_sidebars').length) {
		totalHeight -= $('#footer_sidebars').height();
	}

	if ($('.lc_copy_area ').length) {
		totalHeight -= $('.lc_copy_area').outerHeight(); 
	}

	var minContentHeight = $('#lc_swp_content').data("minheight");
	if ($('#lc_swp_content').length) {
		if (totalHeight > minContentHeight) {
			$('#lc_swp_content').css('min-height', totalHeight); 
		} else {
			$('#lc_swp_content').css('min-height', minContentHeight);
		}
	}

	if ($('.lc_copy_area').length) {
		$('.lc_copy_area').css("opacity", "1");
	}
}

function handleCoverBgImage($) {
	$(".lc_swp_background_image").each(function() {
		var imgSrc = $(this).data("bgimage");
		var bg_position = "center center";

		if ($(this).hasClass('swp_align_bg_img')) {
			bg_position = "center " + $(this).data('valign');
		}

		$(this).css("background-image", "url("+imgSrc+")");
		$(this).css("background-position", bg_position);
		$(this).css("background-repeat", "no-repeat");
		$(this).css("background-size","cover");
	});
}

function handleBgColorAndJsStyle($) {
	$(".lc_swp_overlay").each(function() {
		var bgColor = $(this).data("color");
		
		$(this).parent().css("position", "relative");
		
		$(this).css({
			"background-color" : bgColor,
			"position" : "absolute"
		});
	});

	$(".lc_swp_bg_color").each(function() {
		var bgColor = $(this).data("color");
		$(this).css("background-color", bgColor)
	});

	$(".swp_separator_inner").each(function(){
		$(this).css("width", $(this).data("sepwidth"));
	});

	$(".swp_custom_percentwidth").each(function() {
		$(this).css("width", $(this).data("percentwidth"));
	});

	$(".swp_custom_padding").each(function() {
		var paddings = $(this).data("padding");
		paddings = paddings.split(" ");
		$(this).css("padding-top", paddings[0]+"px");
		$(this).css("padding-right", paddings[1]+"px");
		$(this).css("padding-bottom", paddings[2]+"px");
		$(this).css("padding-left", paddings[3]+"px");
	});

	$(".swp_custom_hovercolor").each(function() {
		var old_bgcolor = $(this).css("background-color");
		var hover_bgcolor = $(this).data("hbgcolor");
		$(this).hover(
			function() {
				$(this).css("background-color", hover_bgcolor);
			}, function() {
				$(this).css("background-color", old_bgcolor);
			}
		);
	});

	$('.swp_mc_subscr_container').each(function(){
		if ($(this).hasClass("user_cust_width")) {
			$(this).css("width", $(this).data("width"));
			$(this).css("max-width", "100%");
		}
	});

	$('.swp_cust_txt_col').each(function(){
		$(this).css("color", $(this).data("txtcol"));
	});

	$('.swp_slide_btn').each(function(){
		var btn_col = $(this).data("bc");
		var btn_bcol = $(this).data("bbc");
		var btn_bdcol = $(this).data("bbdc");
		var btn_hcol = $(this).data("bhc");
		var btn_bhcol = $(this).data("bbhc");
		var btn_bdhcol = $(this).data("bbdhc");

		$(this).find('>a').css("color", btn_col);
		$(this).find('>a').hover(
			function(){
				$(this).css("color", btn_hcol);
			},
			function(){}
		);

		$(this).css({
					"color" : btn_col,
					"background-color" : btn_bcol,
					"border-color" : btn_bdcol
				});
		$(this).hover(
			function() {
				$(this).css({
					"color" : btn_hcol,
					"background-color" : btn_bhcol,
					"border-color" : btn_bdhcol
				});
				$(this).find('>a').css("color", btn_hcol);
			}, function() {
				$(this).css({
					"color" : btn_col,
					"background-color" : btn_bcol,
					"border-color" : btn_bdcol
				});
				$(this).find('>a').css("color", btn_col);
			}
		);
	});
}

function swpMusicPlayer($) {
	$('.swp_music_player').each(function(){

		var item_hover_color = $(this).data("entryhbgcolor");
		$(this).find('.swp_music_player_entry').each(function(){
			$(this).hover(
				function() {
					$(this).css("background-color", item_hover_color);
				}, function() {
					$(this).css("background-color", "transparent");
				}
			);
		});

		var $player = $(this);
		var $play_btn = $player.find('.fa-play.player_play');
		var $pause_btn = $player.find('.fa-pause');
		var $fwd_btn = $player.find('.fa-step-forward');
		var $bkw_btn = $player.find('.fa-step-backward');		
		var $first_song = $player.find('.swp_music_player_entry').first();
		var $last_song = $player.find('.swp_music_player_entry').last();
		var $playing_song_name = $player.find('.current_song_name');
		var $time_slider = $player.find('.player_time_slider');
		var $song_duration = $player.find('.song_duration');
		var $song_current_progress = $player.find('.song_current_progress');
		var autoplay = $player.data('autoplay');

		$player.find('.swp_music_player_entry').each(function(){
			var $player_entry = $(this);
			var audio = new Audio($player_entry.data("mediafile"));
			audio.type= 'audio/mpeg';
			$(this).append(audio);

			audio.onloadedmetadata = function() {
				$player_entry.find('.entry_duration').text(toMinutes(audio.duration));
				if ($first_song.is($player_entry)) {
					$song_duration.text(toMinutes(audio.duration));
				}
			};

			audio.addEventListener("timeupdate", function() {
			    var currentTime = audio.currentTime;
			    var duration = audio.duration;
			    $time_slider.stop(true,true).css('width', (currentTime +.25)/duration*100+'%');
			    $song_current_progress.text(toMinutes(currentTime));
			});			
		});

		/*load the 1st song*/
		$first_song.addClass("now_playing");
		$playing_song_name.text($first_song.find('.player_song_name').text());
		$song_current_progress.text("0:00");
		if ("yes" == autoplay) {
			$first_song.find('audio').get(0).play();
			$play_btn.toggleClass("display_none");
			$pause_btn.toggleClass("display_none");
		}


		$play_btn.click(function() {
			var $crt_elt = $player.find('.swp_music_player_entry.now_playing');
			$crt_elt.find('audio').get(0).play();
			$play_btn.toggleClass("display_none");
			$pause_btn.toggleClass("display_none");
		});
		$pause_btn.click(function() {
			var $crt_elt = $player.find('.swp_music_player_entry.now_playing');
			$crt_elt.find('audio').get(0).pause();
			$play_btn.toggleClass("display_none");
			$pause_btn.toggleClass("display_none");
		});

		$fwd_btn.click(function() {
			var $crt_elt = $player.find('.swp_music_player_entry.now_playing');
			$crt_elt.find('audio').get(0).pause();

			var $next_elt = $crt_elt.next();
			if (!$next_elt.length) {
				$next_elt = $first_song;
			}
			$playing_song_name.text($next_elt.find('.player_song_name').text());
			$next_elt.find('audio').get(0).play();
			$song_duration.text(toMinutes($next_elt.find('audio').get(0).duration));
			$crt_elt.removeClass('now_playing');
			$next_elt.addClass('now_playing');
			$play_btn.addClass("display_none");
			$pause_btn.removeClass("display_none");
		});

		$bkw_btn.click(function() {
			var $crt_elt = $player.find('.swp_music_player_entry.now_playing');
			$crt_elt.find('audio').get(0).pause();
			var $prev_elt = $crt_elt.prev();
			if (!$prev_elt.length) {
				$prev_elt = $last_song;
			}
			$playing_song_name.text($prev_elt.find('.player_song_name').text());
			$prev_elt.find('audio').get(0).play();
			$song_duration.text(toMinutes($prev_elt.find('audio').get(0).duration));
			$crt_elt.removeClass('now_playing');
			$prev_elt.addClass('now_playing');
			$play_btn.addClass("display_none");
			$pause_btn.removeClass("display_none");
		});

		$player.find('.player_entry_left').click(function(){
			var $crt_elt = $player.find('.swp_music_player_entry.now_playing');
			$crt_elt.find('audio').get(0).pause();
			$crt_elt.removeClass('now_playing');

			$(this).parent().addClass('now_playing');
			$(this).parent().find('audio').get(0).play();
			$song_duration.text(toMinutes($(this).parent().find('audio').get(0).duration));
			$playing_song_name.text($(this).find('.player_song_name').text());

			$play_btn.addClass("display_none");
			$pause_btn.removeClass("display_none");			
		});

		$player.find('.player_time_slider_base').click(function(e){
			var $slider_elt = $(this);
			var click_pos = e.pageX - Math.floor($slider_elt.offset().left);
			var elt_width = $slider_elt.width();
			var percent_progress = Math.floor(click_pos/elt_width*100);
			$time_slider.width(percent_progress + "%");

			var $crt_elt = $player.find('.swp_music_player_entry.now_playing');
			$crt_elt.find('audio').get(0).currentTime = $crt_elt.find('audio').get(0).duration * (percent_progress/100);
		});

	});
}

function toMinutes(seconds) {
	seconds = Math.floor(seconds);
	min_part = Math.floor(seconds/60);
	sec_part = seconds % 60;
	if (sec_part < 10) {
		sec_part = '0' + sec_part;
	}
	return min_part + ":" + sec_part;
}

function stickyMenu($) {
	if (!$('header#lc_page_header').hasClass('lc_sticky_menu')) {
		return;
	}

	if ($('.mobile_navigation_container').hasClass('mobile_menu_opened')) {
		return;
	}

	var triggerSticky = 100;
	if ($(window).scrollTop() > triggerSticky) {
		enableSticky($);
	} else {
		disableSticky($);
	}
}

var enableSticky = function($) {
	if ($('header#lc_page_header').hasClass('sticky_enabled')) {
		return;
	}

	$('header#lc_page_header').css("visibility", "hidden")
	$('header#lc_page_header').addClass('sticky_enabled');
	$('header#lc_page_header').css("visibility", "visible");
}

var disableSticky = function($) {
	var element = $('header#lc_page_header');
	if ($(element).hasClass('sticky_enabled')) {
			$(element).removeClass('sticky_enabled');

			if(0 == $(element).attr("class").length) {
				$(element).removeAttr("class");
			}
	}
}

function customPageMenuStyle($) {
    /*no custom styling on sticky menu*/
    if ($('header#lc_page_header').hasClass('sticky_enabled')) {
    	/*logo*/
        if ($('#logo').find('.cust_page_logo').length) {
            $('#logo').find('.cust_page_logo').hide();
            $('#logo').find('.global_logo').show();
        }

         if ($('header#lc_page_header').hasClass('cust_page_menu_style')) {
            $('header#lc_page_header').removeAttr("style");

			/*creative*/
			$('header#lc_page_header').find(".hmb_line").removeAttr("style");
			$('header#lc_page_header').find(".creative_header_icon > a").removeAttr("style");
			$('header#lc_page_header').find(".creative_header_icon > .lnr-magnifier").removeAttr("style");

            /*classic*/
            $('header#lc_page_header').find(".classic_header_icon > a").removeAttr("style");
            $('header#lc_page_header').find(".classic_header_icon > .lnr-magnifier").removeAttr("style");
            $('header#lc_page_header').find(".classic_menu > ul > li:not(.current-menu-parent):not(.current-menu-item) > a").removeAttr("style");

            /*centered*/
            $('header#lc_page_header').find(".lc_social_profile > a").removeAttr("style");
         }

        return;
    }

    if ($('#logo').find('.cust_page_logo').length) {
        $('#logo').find('.cust_page_logo').css("display", "block");
        $('#logo').find('.global_logo').hide();
    }

	if ($('header#lc_page_header').hasClass('cust_page_menu_style')) {
		var menu_bg = $('header#lc_page_header').data("menubg");
        var menu_col = $('header#lc_page_header').data("menucol");
        
        if (menu_bg && (menu_bg != "")) {
            $('header#lc_page_header .header_inner.lc_wide_menu').css("background-color", menu_bg);
        }
        if (menu_col && (menu_col != "")) {
            /*creative*/
            $('header#lc_page_header').find(".hmb_line").not('.mobile_hmb_line').css("background-color", menu_col);
            $('header#lc_page_header').find(".creative_header_icon > a").not('.mobile_menu_icon').css("color", menu_col);
            $('header#lc_page_header').find(".creative_header_icon > .lnr-magnifier").not('.lnr_mobile').css("color", menu_col);

            /*classic*/
            $('header#lc_page_header').find(".classic_header_icon > a").css("color", menu_col);
            $('header#lc_page_header').find(".classic_header_icon > .lnr-magnifier").not('.lnr_mobile').css("color", menu_col);
            $('header#lc_page_header').find(".classic_menu > ul > li:not(.current-menu-parent):not(.current-menu-item) > a").css("color", menu_col);              

            /*centered*/
            $('header#lc_page_header').find(".lc_social_profile > a").css("color", menu_col);
        }
	}
}

function handleVideoImageContainer($) {
	if (!$('.video_image_container').length) {
		return;
	}

	$('.video_image_container').each(function() {
		var no_px_width = parseFloat($(this).css('width'));
		$(this).css("height", no_px_width * 9/16);
		$(this).parent().parent().css("opacity", 1);
	});
}

function handleAlbumImageContainer($) {
	if (!$('.album_image_container').length) {
		return;
	}

	$('.album_image_container').each(function() {
		var no_px_width = parseFloat($(this).css('width'));
		$(this).css("height", no_px_width);
		$(this).parent().parent().parent().css("opacity", 1);
	});	
}

function handleArtistTemplateSingles($) {
	if (!$('.artist_img_container').length) {
		return;
	}

	$('.artist_img_container').each(function() {
		var no_px_width = parseFloat($(this).css('width'));
		$(this).css("height", no_px_width);
		$(this).parent().css("opacity", 1);
	});

	$('.single_artist_item').each(function(){
		$(this).css("margin-bottom", "");

		var $atitle = $(this).find('.artist_title');
		var height_std = parseInt($atitle.css("line-height"));
		var height_act = $atitle.height();
		var std_margin = parseInt($(this).css("margin-bottom"));
		if (height_std != height_act) {
			$(this).css("margin-bottom", std_margin - height_act + height_std);
		}
	});
}

function runMasonryGallery($) {
	if (!$('.lc_masonry_container').length) {
		return;
	}

	var $grid = $('.lc_masonry_container').imagesLoaded(function() {

		$grid.find('.lc_single_gallery_brick').each(function(){
			var brick_height = Math.ceil($(this).find('img').height()); 
			$(this).css("height", brick_height);
		});

		$grid.masonry({
			itemSelector: '.lc_masonry_brick',
			percentPosition: true,
			columnWidth: '.brick-size',
		}); 
	});
}

var hanldeJsLinks = function($) {
	if (!$('.lc_js_link').length) {
		return;
	}

	$('.lc_js_link').click(function(event) {
		event.preventDefault();
		var newLocation = $(this).data("href");
		var newWin = '';
		if ($(this).data("target")) {
			newWin = $(this).data("target");
		}
		window.open(newLocation, newWin);
	});
}

var logoInTheMiddle = function($) {
	if (!$('.header_centered_menu_logo_center').length) {
		return;
	}

	var middleMenuPosition = Math.ceil($(".header_inner.centered_menu_logo_center ul.menu > li").length / 2);
	$(".header_inner.centered_menu_logo_center ul.menu > li:nth-child(" + middleMenuPosition + ")").after('<li class="logo_menu_item"></li>');	
	$('#logo').detach().appendTo('li.logo_menu_item');
	$('#logo').css("opacity", "1");
	$(".header_inner.centered_menu_logo_center").animate({ opacity: 1 }, "slow");
}

function handleAsideMenu($) {
	if (!$('.trigger_aside_menu')) {
		return;
	}

	$('.trigger_aside_menu').click(function(){
		$('#swp_side_menu').toggleClass('show_aside');
		$('#lc_swp_wrapper').toggleClass('show_aside');
		$('body').toggleClass('show_aside');
	});
	$('.hmb_close').click(function(){
		$('#swp_side_menu').removeClass('show_aside');
		$('#lc_swp_wrapper').removeClass('show_aside');
		$('body').removeClass('show_aside');
	});
}

var customAspectRatio = function($) {
    $('.swp_custom_ar').each(function() {
        if ( $( this ).hasClass( "ar_square" ) ) {
            $( this ).css( "height", $( this ).width() );
        }    	
        if ($(this).hasClass("ar_43")) {
            $(this).css("height", $(this).width() / 4 * 3);
        }
        if ($(this).hasClass("ar_169")) {
            $(this).css("height", $(this).width() / 16 * 9);
        }
		if ($(this).hasClass("ar_1910")) {
            $(this).css("height", $(this).width() / 19 * 10);
        }        
    });
}

var handleVideoSection = function($) {
    $('.video_scd_btn_play').click(function() {
        var video_source = $(this).parent().data("vsource");
        var video_id = $(this).parent().data("vid");

        var video_frame = '';
        if ("youtube" == video_source) {
            video_frame = '<iframe class="at_video_frame" src="' + location.protocol + '//www.youtube.com/embed/' + video_id + '?autoplay=1&amp;showinfo=0&amp;rel=0&amp;byline=0&amp;title=0&amp;portrait=0"></iframe>';
        }
        else if ("vimeo" == video_source) {
            video_frame = '<iframe class="at_video_frame" src="' + location.protocol + '//player.vimeo.com/video/' + video_id + '?autoplay=1&amp;byline=0&amp;title=0&amp;portrait=0"></iframe>';
        }

        $(this).parent().append(video_frame);
        $(this).fadeOut();
    });

    $('.video_play_btn_scd').click(function() {

        $('body').css("overflow-y", "hidden");
        var video_overlay = '<div class="swp_video_overlay"><div class="swp_video_overlay_inner"><div class="swp_video_iframe_container"></div></div><i class="close_swp_video_overlay far fa-times-circle"></i></div>';
        $('body').append(video_overlay);

    	var video_source = $(this).data("vsource");
    	var video_id = $(this).data("vid");
        var video_frame = '';
        if ("youtube" == video_source) {
            video_frame = '<iframe class="at_video_frame" src="' + location.protocol + '//www.youtube.com/embed/' + video_id + '?autoplay=1&amp;showinfo=0&amp;rel=0&amp;byline=0&amp;title=0&amp;portrait=0"></iframe>';
        }
        else if ("vimeo" == video_source) {
            video_frame = '<iframe class="at_video_frame" src="' + location.protocol + '//player.vimeo.com/video/' + video_id + '?autoplay=1&amp;byline=0&amp;title=0&amp;portrait=0"></iframe>';
        }
        
        
        $('.swp_video_iframe_container').append(video_frame);

	    $('.close_swp_video_overlay').click(function(){
	    	$('.swp_video_overlay').remove();
	    	$('body').css("overflow-y", "auto");
	    });        
    });

}

function runUnslider($) {
	$('.lc_reviews_slider').each(function(){
		var slide_speed = 400;
		var slide_delay = 4000;

		if (typeof $(this).parent().data('slidespeed') !== 'undefined') {
			slide_speed = $(this).parent().data('slidespeed');
		}
		if (typeof $(this).parent().data('slidedelay') !== 'undefined') {
			slide_delay = $(this).parent().data('slidedelay');
		}

		var arrows_val = {
				prev: '<a class="unslider-arrow prev"><div class="swp_unslider_arrow swp_arrow_left"></div></a>',
				next: '<a class="unslider-arrow next"><div class="swp_unslider_arrow swp_arrow_right"></div></a>',
			};
		if (1 == $(this).find('li').length) {
			arrows_val = false;
		}

		$(this).unslider({
			arrows: arrows_val,
			autoplay: true,
			nav: false,
			delay: slide_delay,
			speed: slide_speed
		});

		$(this).fadeTo("slow", 1);
	});
}


function runMasonryForBlog ( $ ) {
    if ( ! $( '.lc_blog_masonry_container' ).length ) {
        return;
    }

    var $grid = $( '.lc_blog_masonry_container' ).imagesLoaded( function() {
        var gap_width = $grid.data( "gapwidth" );
        var container_width = $grid.width();
        var container_outer_width = $grid.outerWidth();
        var bricks_on_row = $grid.data( "bricksonrow" );


        var bricks_on_row_responsive = getMasonryBricksOnRow( $, bricks_on_row, container_outer_width );
        var brick_width = (container_width - (bricks_on_row_responsive - 1) * gap_width) / bricks_on_row_responsive;

        $( ".lc_blog_masonry_brick" ).css( "width", brick_width );
        $grid.masonry( {
            columnWidth  : brick_width,
            itemSelector : '.lc_blog_masonry_brick',
            gutter       : gap_width
        } );
        $grid.fadeTo("600", 1);
    } );
}

function getMasonryBricksOnRow ($, default_number, container_outer_width, breakpoints) {
    if (undefined === breakpoints) {
        breakpoints = {1: 480, 2: 980, 3: 1680 };
    }

    if ( container_outer_width <= breakpoints[1] ) {
        return 1;
    }
    else if ( container_outer_width <= breakpoints[2] ) {
        return 2;
    }
    else if ( container_outer_width <= breakpoints[3] ) {
        return 3;
    }
    else {
        return default_number;
    }
}

function handleCountdown($) {
	$('.swp_event_countdown').each(function(){
		var countDownDate = new Date($(this).data("todate")).getTime();
	

	var countDate = new Date($(this).data("todate"));
		var $container = $(this);
		var x = setInterval(function() {

		  // Get todays date and time
		  var now = new Date().getTime();

		  // Find the distance between now an the count down date
		  var distance = countDownDate - now;

		  // Time calculations for days, hours, minutes and seconds
		  var days = Math.floor(distance / (1000 * 60 * 60 * 24));
		  var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
		  var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
		  var seconds = Math.floor((distance % (1000 * 60)) / 1000);

		  // Display the result in the element with id="demo"
		  $container.find('.days_amount').html(days);
		  $container.find('.hours_amount').html(hours);
		  $container.find('.mins_amount').html(minutes);
		  $container.find('.seconds_amount').html(seconds);

		}, 1000);		
	});
}

function justifiedGallery($) {
	if (!$('.lc_swp_justified_gallery').length) {
		return;
	}

	$(".lc_swp_justified_gallery").each(function() {
		var rowHeight = $(this).data("rheight");
		if (!$.isNumeric(rowHeight)) {
			rowHeight = 180;
		}

		$(this).justifiedGallery({
			rowHeight: rowHeight,
			lastRow: 'justify',
			margins: 0,
			captions: false,
			imagesAnimationDuration: 400
		});

		//$(this).find("img").fadeTo("600", 0.6);
	});

	setTimeout(function(){
		$('.img_box').find("img").addClass("transition4");
	}, 600);
}