/**
 * This file adds some LIVE to the Theme Customizer live preview. To leverage
 * this, set your custom settings to 'postMessage' and then add your handling
 * here. Your javascript should grab settings from customizer controls, and 
 * then make any necessary changes to the page using jQuery.
 */
 (function($) {
	'use strict';

	wp.customize('lc_customize[second_color]', function(value) {
		value.bind(function(newval) {
			/*text color*/
			$('a:hover, #swp_side_menu a:hover, .vibrant_color, .lc_vibrant_color, .heading_area_subtitle h2, .swp_button_naked, .lc_reviewer_name').css('color', newval);
			$('.swp_cf_error, .form_result_error, .album_featured_text, i.before_song, .woocommerce-info::before, .woocommerce ul.products li.product .price').css('color', newval);
			$('.woocommerce div.product p.price, .woocommerce-message::before, .woocommerce form .form-row .required, blockquote cite a').css('color', newval);
			$('.ec_timer_entry, .wp-caption-text a, .transparent_bg .ec_user_text, .transparent_bg a.ec_title_link').css('color', newval);

			/*background*/
			$('.cart-contents-count, .photo_gallery_overlay, .album_overlay, .video_scd_btn_play, .video_play_btn_scd, .swp_separator_inner, .player_time_slider').css('background-color', newval);
			$('.lc_button.lc_button_fill, .woocommerce span.onsale, .latest_albums_overlay, .swp_event_countdown, .gallery_brick_overlay.gallery_scd_overlay').css('background-color', newval);
			$('.woocommerce button.button, .event_card_overlay').css('background-color', newval);
			/*border color*/
			$('.lc_button.lc_button_fill, .woocommerce-info, .woocommerce-message, .woocommerce button.button').css('border-color', newval);
		});
	});	

	wp.customize('lc_customize[menu_bar_bg_color]', function(value) {
		value.bind(function(newval) {
			$('header#lc_page_header .header_inner').css('background-color', newval);
		});
	});

	wp.customize('lc_customize[menu_sticky_bar_bg_color]', function(value) {
		value.bind(function(newval) {
			$('header#lc_page_header.sticky_enabled').css('background-color', newval);
		});
	});	

	wp.customize('lc_customize[menu_text_color]', function(value) {
		value.bind(function(newval) {
			$('#lc_page_header ul.menu > li > a, #logo a, .classic_header_icon, .classic_header_icon a, .classic_header_icon a:hover').children().children('a').css('color', newval);
			$('.mobile_menu_icon a, .mobile_menu_icon a:hover, .mobile_menu_icon').css('color', newval);

			$('#lc_page_header .hmb_line').css('background-color', newval);
		});
	});

	wp.customize('lc_customize[menu_text_hover_color]', function(value) {
		var oldVal = $('#lc_page_header ul.menu').children().children('a').css('color');
		value.bind(function(newval) {
			$('#lc_page_header ul.menu').children().children('a').hover(function(){
			    $(this).css("color", newval);
			    }, function(){
			    $(this).css("color", oldVal);
			});
		});
	});

	wp.customize('lc_customize[submenu_bg_color]', function(value) {
		value.bind(function(newval) {
			$('#lc_page_header ul.sub-menu li').css('background-color', newval);
		});
	});	

	wp.customize('lc_customize[submenu_text_color]', function(value) {
		value.bind(function(newval) {
			$('#lc_page_header ul.sub-menu li a').css('color', newval);
		});
	});

	wp.customize('lc_customize[submenu_text_hover_color]', function(value) {
		var oldVal = $("#lc_page_header ul.sub-menu li a").css('color');

		value.bind(function(newval) {
			$("lc_page_header ul.sub-menu li a").hover(function(){
			    $(this).css("color", newval);
			}, function(){
			    $(this).css("color", oldVal);
			});	
		});
	});

	wp.customize('lc_customize[current_menu_item_text_color]', function(value) {
		value.bind(function(newval) {
			$('li.current-menu-item > a, li.current-menu-parent a, li.current-menu-ancestor a').css('color', newval);
		});
	});

	wp.customize('lc_customize[menu_mobile_bg_color]', function(value) {
		value.bind(function(newval) {
			$('.header_inner.lc_mobile_menu, .mobile_navigation_container').css('background-color', newval);
		});
	});

	wp.customize('lc_customize[mobile_border_bottom_color]', function(value) {
		value.bind(function(newval) {
			$('.mobile_navigation ul li').css('border-bottom-color', newval);
		});
	});

	wp.customize('lc_customize[album_track_bg]', function(value) {
		value.bind(function(newval) {
			$('.widget_media_audio .mejs-container .mejs-controls, .widget_media_video  .mejs-container .mejs-controls, .lnwidtget_no_featured_img').css('background-color', newval);
			$('.gallery_brick_overlay, .single_track, .single_track .mejs-container .mejs-controls, article.no_thumbnail.sticky').css('background-color', newval);
			$('li.bypostauthor').css('background-color', newval);
			
			$('.event_buy_btn.event_sold_out, .event_buy_btn.event_canceled, .lc_button.event_sold_out, .lc_button.event_sold_out:hover').css('background-color', newval);
			$('.lc_button.event_canceled, .lc_button.event_canceled:hover').css('background-color', newval);
			$('.event_buy_btn.event_sold_out, .event_buy_btn.event_canceled, .lc_button.event_sold_out, .lc_button.event_sold_out:hover').css('border-color', newval);
			$('.lc_button.event_canceled, .lc_button.event_canceled:hover').css('border-color', newval);			
		});
	});		


})(jQuery);