<?php
/*
	Theme Customiser Functionality
	Contains methods for customizing the theme customization screen.
*/
class SLIDE_SWP_Customize {
	//This hooks into 'customize_register' (available as of WP 3.4)
	public static function register($wp_customize) {

		require_once(get_template_directory()."/customizer/alpha-color-picker-customizer.php");

		// if (!isset($lc_customize['menu_mobile_bg_color'])) {
		// 	$lc_customize['menu_mobile_bg_color'] = 'rgba(35, 35, 35, 1)';
		// }

		//Define a new section (if desired) to the Theme Customizer
		/*
			VIBRANT COLOR
		*/
		$wp_customize->add_section( 'lc_second_color', 
			array(
				'title' => esc_html__('Vibrant Color', 'slide'), 				//Visible title of section
				'priority' => 1, 											//Determines what order this appears in
				'capability' => 'edit_theme_options', 						//Capability needed to tweak
				'description' => esc_html__('Choose the link color', 'slide'), //Descriptive tooltip
			)
		);

		//Register new settings to the WP database...
		$wp_customize->add_setting( 'lc_customize[lc_second_color]', 	//Give it a SERIALIZED name (so all theme settings can live under one db record)
			array(
				'default' => '#fb3a64', 										//Default setting/value to save
				'sanitize_callback' => 'sanitize_hex_color',					//Sanitizer
				'type' => 'option', 											//Is this an 'option' or a 'theme_mod'?
				'capability' => 'edit_theme_options', 							//Optional. Special permissions for accessing this setting.
				'transport' => 'postMessage', 									//What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
			) 
		);

		//Finally, we define the control itself (which links a setting to a section and renders the HTML controls)...
		$wp_customize->add_control( new WP_Customize_Color_Control( //Instantiate the color control class
										$wp_customize, 				//Pass the $wp_customize object (required)
										'lc_second_color', 			//Set a unique ID for the control
										array(
										'label' => esc_html__('Secondary Color', 'slide'), //Admin-visible name of the control
										'section' => 'lc_second_color', //ID of the section (can be one of yours, or a WordPress default section)
										'settings' => 'lc_customize[lc_second_color]', //Which setting to load and manipulate (serialized is okay)
										'priority' => 1, //Determines the order this control appears in for the specified section
										) 
		));

		/*
			MENU COLORS
		*/
		$wp_customize->add_section('lc_menu_options', 
			array(
				'title' => esc_html__('Menu Colors', 'slide'), 				//Visible title of section
				'priority' => 2, 											//Determines what order this appears in
				'capability' => 'edit_theme_options', 						//Capability needed to tweak
				'description' => esc_html__('Choose menu colors', 'slide'), //Descriptive tooltip
			)
		);
		/*menu bar bg color*/
		$wp_customize->add_setting('lc_customize[menu_bar_bg_color]',
			array(
				'default' => 'rgba(27,29,47,1)', 												//Default setting/value to save
				'sanitize_callback' => 'SLIDE_SWP_sanitize_rgba_color',							//Sanitizer
				'type' => 'option', 													//Is this an 'option' or a 'theme_mod'?
				'capability' => 'edit_theme_options', 									//Optional. Special permissions for accessing this setting.
				'transport' => 'postMessage' 											//What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
			)
		);
		$wp_customize->add_control(
			new Customize_Alpha_Color_Control( 												//Instantiate the color control class
				$wp_customize, 																//Pass the $wp_customize object (required)
				'menu_bar_bg_color', 														//Set a unique ID for the control
				array(
				'label' => esc_html__('Menu Bar Background Color', 'slide'), 							//Admin-visible name of the control
				'section' => 'lc_menu_options', 								// ID of the section this control should render in (can be one of yours, or a WordPress default section)
				'settings' => 'lc_customize[menu_bar_bg_color]', 						//Which setting to load and manipulate (serialized is okay)
				'priority' => 1															//Determines the order this control appears in for the specified section
				)
		));
		/*sticky menu bar color*/
		$wp_customize->add_setting('lc_customize[menu_sticky_bar_bg_color]',
			array(
				'default' => 'rgba(27,29,47,1)', 												//Default setting/value to save
				'sanitize_callback' => 'SLIDE_SWP_sanitize_rgba_color',							//Sanitizer
				'type' => 'option', 													//Is this an 'option' or a 'theme_mod'?
				'capability' => 'edit_theme_options', 									//Optional. Special permissions for accessing this setting.
				'transport' => 'postMessage' 											//What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
			)
		);
		$wp_customize->add_control(
			new Customize_Alpha_Color_Control( 												//Instantiate the color control class
				$wp_customize, 																//Pass the $wp_customize object (required)
				'menu_sticky_bar_bg_color', 														//Set a unique ID for the control
				array(
				'label' => esc_html__('Sticky Menu Bar Background Color', 'slide'), 							//Admin-visible name of the control
				'section' => 'lc_menu_options', 								// ID of the section this control should render in (can be one of yours, or a WordPress default section)
				'settings' => 'lc_customize[menu_sticky_bar_bg_color]', 						//Which setting to load and manipulate (serialized is okay)
				'priority' => 2														//Determines the order this control appears in for the specified section
				)
		));

		/*menu text color*/
		$wp_customize->add_setting('lc_customize[menu_text_color]',
			array(
				'default' => '#ffffff', 												//Default setting/value to save
				'sanitize_callback' => 'sanitize_hex_color',							//Sanitizer
				'type' => 'option', 													//Is this an 'option' or a 'theme_mod'?
				'capability' => 'edit_theme_options', 									//Optional. Special permissions for accessing this setting.
				'transport' => 'postMessage' 											//What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'lc_menu_text_color',	 			//Set a unique ID for the control
				array(
				'label' => esc_html__('Menu Text Color', 'slide'),
				'section' => 'lc_menu_options',	//ID of the section (can be one of yours, or a WordPress default section)
				'settings' => 'lc_customize[menu_text_color]',
				'priority' => 3,
			)
		));

		/*menu text hover color*/
		$wp_customize->add_setting('lc_customize[menu_text_hover_color]',
			array(
				'default' => '#da4972', 												//Default setting/value to save
				'sanitize_callback' => 'sanitize_hex_color',							//Sanitizer
				'type' => 'option', 													//Is this an 'option' or a 'theme_mod'?
				'capability' => 'edit_theme_options', 									//Optional. Special permissions for accessing this setting.
				'transport' => 'postMessage' 											//What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'lc_menu_text_hover_color',	 			//Set a unique ID for the control
				array(
				'label' => esc_html__('Menu Text Color on Hover', 'slide'),
				'section' => 'lc_menu_options',	//ID of the section (can be one of yours, or a WordPress default section)
				'settings' => 'lc_customize[menu_text_hover_color]',
				'priority' => 4
			) 
		));

		/*sub menu bg color*/
		$wp_customize->add_setting('lc_customize[submenu_bg_color]',
			array(
				'default' => 'rgba(38, 41, 66,1)', 												//Default setting/value to save
				'sanitize_callback' => 'SLIDE_SWP_sanitize_rgba_color',							//Sanitizer
				'type' => 'option', 													//Is this an 'option' or a 'theme_mod'?
				'capability' => 'edit_theme_options', 									//Optional. Special permissions for accessing this setting.
				'transport' => 'postMessage' 											//What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
			)
		);

		$wp_customize->add_control(
			new Customize_Alpha_Color_Control( 												//Instantiate the color control class
				$wp_customize, 																//Pass the $wp_customize object (required)
				'submenu_bg_color', 														//Set a unique ID for the control
				array(
				'label' => esc_html__('Sub Menu Background Color', 'slide'), 							//Admin-visible name of the control
				'section' => 'lc_menu_options', 								// ID of the section this control should render in (can be one of yours, or a WordPress default section)
				'settings' => 'lc_customize[submenu_bg_color]', 						//Which setting to load and manipulate (serialized is okay)
				'priority' => 5															//Determines the order this control appears in for the specified section
				)
		));

		/*sub menu text color*/
		$wp_customize->add_setting('lc_customize[submenu_text_color]',
			array(
				'default' => '#ffffff', 												//Default setting/value to save
				'sanitize_callback' => 'sanitize_hex_color',							//Sanitizer
				'type' => 'option', 													//Is this an 'option' or a 'theme_mod'?
				'capability' => 'edit_theme_options', 									//Optional. Special permissions for accessing this setting.
				'transport' => 'postMessage' 											//What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'lc_submenu_text_color',	 			//Set a unique ID for the control
				array(
				'label' => esc_html__('Sub Menu Text Color', 'slide'),
				'section' => 'lc_menu_options',	//ID of the section (can be one of yours, or a WordPress default section)
				'settings' => 'lc_customize[submenu_text_color]',
				'priority' => 6,
			)
		));

		/*submenu text hover color*/
		$wp_customize->add_setting('lc_customize[submenu_text_hover_color]',
			array(
				'default' => '#da4972',													//Default setting/value to save
				'sanitize_callback' => 'sanitize_hex_color',							//Sanitizer
				'type' => 'option', 													//Is this an 'option' or a 'theme_mod'?
				'capability' => 'edit_theme_options', 									//Optional. Special permissions for accessing this setting.
				'transport' => 'postMessage' 											//What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'lc_submenu_text_hover_color',	 			//Set a unique ID for the control
				array(
				'label' => esc_html__('Sub Menu Text Color on Hover', 'slide'),
				'section' => 'lc_menu_options',	//ID of the section (can be one of yours, or a WordPress default section)
				'settings' => 'lc_customize[submenu_text_hover_color]',
				'priority' => 7,
			)
		));

		/*current menu item text color*/
		$wp_customize->add_setting('lc_customize[current_menu_item_text_color]',
			array(
				'default' => '#da4972',													//Default setting/value to save
				'sanitize_callback' => 'sanitize_hex_color',							//Sanitizer
				'type' => 'option', 													//Is this an 'option' or a 'theme_mod'?
				'capability' => 'edit_theme_options', 									//Optional. Special permissions for accessing this setting.
				'transport' => 'postMessage' 											//What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'lc_current_menu_item_text_color',	 			//Set a unique ID for the control
				array(
				'label' => esc_html__('Current Menu Item Text Color', 'slide'),
				'section' => 'lc_menu_options',	//ID of the section (can be one of yours, or a WordPress default section)
				'settings' => 'lc_customize[current_menu_item_text_color]',
				'priority' => 8,
			)
		));

		/*mobile menu bar color*/
		$wp_customize->add_setting('lc_customize[menu_mobile_bg_color]',
			array(
				'default' => 'rgba(27,29,47,1)', 												//Default setting/value to save
				'sanitize_callback' => 'SLIDE_SWP_sanitize_rgba_color',							//Sanitizer
				'type' => 'option', 													//Is this an 'option' or a 'theme_mod'?
				'capability' => 'edit_theme_options', 									//Optional. Special permissions for accessing this setting.
				'transport' => 'postMessage' 											//What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
			)
		);
		$wp_customize->add_control(
			new Customize_Alpha_Color_Control( 												//Instantiate the color control class
				$wp_customize, 																//Pass the $wp_customize object (required)
				'menu_mobile_bg_color', 														//Set a unique ID for the control
				array(
				'label' => esc_html__('Mobile Menu Background Color', 'slide'), 							//Admin-visible name of the control
				'section' => 'lc_menu_options', 								// ID of the section this control should render in (can be one of yours, or a WordPress default section)
				'settings' => 'lc_customize[menu_mobile_bg_color]', 						//Which setting to load and manipulate (serialized is okay)
				'priority' => 1															//Determines the order this control appears in for the specified section
				)
		));

		/*mobile menu border bottom color*/
		$wp_customize->add_setting('lc_customize[mobile_border_bottom_color]',
			array(
				'default' => 'rgba(47, 50, 78, 1)', 												//Default setting/value to save
				'sanitize_callback' => 'SLIDE_SWP_sanitize_rgba_color',							//Sanitizer
				'type' => 'option', 													//Is this an 'option' or a 'theme_mod'?
				'capability' => 'edit_theme_options', 									//Optional. Special permissions for accessing this setting.
				'transport' => 'postMessage' 											//What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
			)
		);

		$wp_customize->add_control(
			new Customize_Alpha_Color_Control( 												//Instantiate the color control class
				$wp_customize, 																//Pass the $wp_customize object (required)
				'mobile_border_bottom_color', 														//Set a unique ID for the control
				array(
				'label' => esc_html__('Mobile Menu Border Bottom Color', 'slide'), 							//Admin-visible name of the control
				'section' => 'lc_menu_options', 								// ID of the section this control should render in (can be one of yours, or a WordPress default section)
				'settings' => 'lc_customize[mobile_border_bottom_color]', 						//Which setting to load and manipulate (serialized is okay)
				'priority' => 1															//Determines the order this control appears in for the specified section
				)
		));

		/*
			VARIOUS COLORS
		*/
		$wp_customize->add_section('lc_various_colors', 
			array(
				'title' => esc_html__('Various Colors', 'slide'), 				//Visible title of section
				'priority' => 3, 											//Determines what order this appears in
				'capability' => 'edit_theme_options', 						//Capability needed to tweak
				'description' => esc_html__('Various website colors like background for album tracks or canceled event buttons', 'slide'), //Descriptive tooltip
			)
		);
		/*album track bg color*/
		$wp_customize->add_setting('lc_customize[album_track_bg]',
			array(
				'default' => '#1c1f32', 												//Default setting/value to save
				'sanitize_callback' => 'sanitize_hex_color',							//Sanitizer
				'type' => 'option', 													//Is this an 'option' or a 'theme_mod'?
				'capability' => 'edit_theme_options', 									//Optional. Special permissions for accessing this setting.
				'transport' => 'postMessage' 											//What triggers a refresh of the setting? 'refresh' or 'postMessage' (instant)?
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control( 												//Instantiate the color control class
				$wp_customize, 																//Pass the $wp_customize object (required)
				'album_track_bg', 														//Set a unique ID for the control
				array(
				'label' => esc_html__('Album Tracks & Canceled Button Background Color', 'slide'), 							//Admin-visible name of the control
				'section' => 'lc_various_colors', 								// ID of the section this control should render in (can be one of yours, or a WordPress default section)
				'settings' => 'lc_customize[album_track_bg]', 						//Which setting to load and manipulate (serialized is okay)
				'priority' => 1															//Determines the order this control appears in for the specified section
				)
		));
	}

	/**
	* This outputs the javascript needed to automate the live settings preview.
	* keep 'transport'=>'postMessage' instead of the default 'transport' => 'refresh'
	* Used by hook: 'customize_preview_init'
	*/
	public static function live_preview() {
		wp_enqueue_script( 
	       'slide-themecustomizer', 											// Give the script a unique ID
	       get_template_directory_uri().'/customizer/js/theme_customizer.js', 	// Define the path to the JS file
	       array('jquery', 'customize-preview'),				 				// Define dependencies
	       rand(5, 100), 																	// Define a version (optional) 
	       true 																// Specify whether to put in footer (leave this true)
		);
	}

   /**
    * This will output the custom WordPress settings to the live theme's WP head.
    * Used by hook: 'wp_head'
    * add_action('wp_head',$func)
    */
	public static function header_output() {
		$lc_customize = get_option('lc_customize');

		if (!isset($lc_customize['lc_second_color'])) {
			$lc_customize['lc_second_color'] = '#fb3a64';
		}
		if (!isset($lc_customize['menu_bar_bg_color'])) {
			$lc_customize['menu_bar_bg_color'] = 'rgba(27,29,47,1)';
		}
		if (!isset($lc_customize['menu_sticky_bar_bg_color'])) {
			$lc_customize['menu_sticky_bar_bg_color'] = 'rgba(27,29,47,1)';
		}
		if (!isset($lc_customize['menu_text_color'])) {
			$lc_customize['menu_text_color'] = '#ffffff';
		}
		if (!isset($lc_customize['menu_text_hover_color'])) {
			$lc_customize['menu_text_hover_color'] = '#da4972';
		}
		if (!isset($lc_customize['submenu_bg_color'])) {
			$lc_customize['submenu_bg_color'] = 'rgba(38, 41, 66,1)';
		}
		if (!isset($lc_customize['submenu_text_color'])) {
			$lc_customize['submenu_text_color'] = '#ffffff';
		}
		if (!isset($lc_customize['submenu_text_hover_color'])) {
			$lc_customize['submenu_text_hover_color'] = '#da4972';
		}
		if (!isset($lc_customize['current_menu_item_text_color'])) {
			$lc_customize['current_menu_item_text_color'] = '#da4972';	
		}
		if (!isset($lc_customize['menu_mobile_bg_color'])) {
			$lc_customize['menu_mobile_bg_color'] = 'rgba(27,29,47,1)';	
		}
		if (!isset($lc_customize['mobile_border_bottom_color'])) {
			$lc_customize['mobile_border_bottom_color'] = 'rgba(47, 50, 78, 1)';
		}
		if (!isset($lc_customize['album_track_bg'])) {
			$lc_customize['album_track_bg'] = '#1c1f32';
		}
		?>
		<!--Customizer CSS-->
		<style type="text/css">

			<?php 
			/*vibrant color as text color*/ 
			?>
			a:hover, #swp_side_menu a:hover, .vibrant_color, .lc_vibrant_color, .heading_area_subtitle h2, #sidebar a:hover, #sidebar .widget.widget_recent_comments  a:hover, 
			.footer_w_social_icon a:hover, h3.video_title:hover, .lc_reviewer_name,
			.lc_blog_masonry_brick:hover .masonry_post_title, input[type="submit"].at_news_button_entry:hover, .swp_cf_error, .form_result_error, .album_featured_text,
			i.before_song, blockquote cite a, .woocommerce-info::before, .woocommerce ul.products li.product .price, .woocommerce div.product p.price, .woocommerce-message::before,
			.woocommerce form .form-row .required, .ec_timer_entry, .lc_footer_sidebar.white_on_black a:hover, .lc_footer_sidebar.black_on_white a:hover,
			.wp-caption-text a, .transparent_bg .ec_user_text, .transparent_bg a.ec_title_link
			{ color: <?php echo esc_html($lc_customize['lc_second_color']); ?>; }

			<?php 
			/*vibrant color as background*/
			?>
			.cart-contents-count, #commentform input#submit:hover, .single_video_item:hover i, .event_buy_btn.lc_js_link:hover, 
			.single_event_list:hover .event_buy_btn.lc_js_link, .photo_gallery_overlay, .lc_button:hover, .lc_button.lc_button_fill, .album_overlay, .video_scd_btn_play, .swp_separator_inner, .video_play_btn_scd,
			a.masonry_read_more:hover .swp_before_right_arrow, .swp_player_bottom_inner i.fa-pause, .swp_player_bottom_inner i.fa-play, .player_time_slider,
			input[type="submit"]:hover, .woocommerce span.onsale, .woocommerce a.button:hover, .woocommerce ul.products li:hover > a.button, .woocommerce button.button.alt,
			.woocommerce button.button.alt:hover, .woocommerce #respond input#submit:hover, .woocommerce-cart table.cart input[type="submit"]:hover,
			.woocommerce a.button.alt:hover, .latest_albums_overlay, .swp_event_countdown, .gallery_brick_overlay.gallery_scd_overlay, .woocommerce button.button,
			.woocommerce button.button.alt.disabled, .woocommerce button.button.alt.disabled:hover, .event_card_overlay
			{ background-color: <?php echo esc_html($lc_customize['lc_second_color']); ?>; }

			<?php
			/*vibrant color as border color*/
			?>
			.mobile_navigation ul li.menu-item-has-children::before
			{ border-left-color: <?php echo esc_html($lc_customize['lc_second_color']); ?>; }

			<?php
			/*vibrant color as border color*/
			?>			
 			#commentform input#submit:hover, .single_video_item:hover i, .event_buy_btn.lc_js_link, .lc_button:hover, .lc_button.lc_button_fill,
 			input[type="submit"]:hover, .woocommerce-info, .woocommerce-message, .woocommerce a.button:hover, .woocommerce ul.products li:hover > a.button, .woocommerce button.button.alt, .woocommerce button.button,
 			.woocommerce #respond input#submit:hover, input.lucille_cf_input:focus, textarea.lucille_cf_input:focus
 			{ border-color: <?php echo esc_html($lc_customize['lc_second_color']); ?> !important; }
			<?php
			/*menu bar bg color*/
			?>
			header#lc_page_header .header_inner
			{ background-color: <?php echo esc_html($lc_customize['menu_bar_bg_color']); ?>; }

			<?php 
			/*sticky menu bar bg color*/
			?>
			header#lc_page_header.sticky_enabled
			{ background-color: <?php echo esc_html($lc_customize['menu_sticky_bar_bg_color']); ?>; }

			<?php 
			/*menu text color*/
			?>
			#lc_page_header ul.menu > li > a, #lc_page_header .mobile_navigation ul.sub-menu li a, 
			#logo a, .classic_header_icon, .classic_header_icon a, .classic_header_icon a:hover,
			.mobile_menu_icon a, .mobile_menu_icon a:hover, .mobile_menu_icon
			{ color: <?php echo esc_html($lc_customize['menu_text_color']); ?>; }

			<?php 
			/*menu text color as bg color for HMB menu*/
			?>
			#lc_page_header .hmb_line
			{ background-color: <?php echo esc_html($lc_customize['menu_text_color']); ?>; }


			<?php 
			/*menu text color on hover*/
			?>
			#lc_page_header ul.menu > li > a:hover
			{ color: <?php echo esc_html($lc_customize['menu_text_hover_color']); ?>; }

			<?php 
			/*sub menu bg color*/
			?>
			#lc_page_header ul.sub-menu li
			{ background-color: <?php echo esc_html($lc_customize['submenu_bg_color']); ?>; }

			<?php 
			/*sub menu text color*/
			?>
			#lc_page_header ul.sub-menu li a
			{ color: <?php echo esc_html($lc_customize['submenu_text_color']); ?>; }

			<?php 
			/*sub menu text hover color*/
			?>
			#lc_page_header ul.sub-menu li a:hover
			{ color: <?php echo esc_html($lc_customize['submenu_text_hover_color']); ?>; }

			<?php 
			/*current menu item text color*/
			?>
			#lc_page_header ul.menu li.current-menu-item > a, li.current-menu-parent > a, li.current-menu-ancestor > a
			{ color: <?php echo esc_html($lc_customize['current_menu_item_text_color']); ?>; }

			<?php 
			/*mobile menu bg color*/
			?>
			.header_inner.lc_mobile_menu, .mobile_navigation_container
			{ background-color: <?php echo esc_html($lc_customize['menu_mobile_bg_color']); ?>; }

			<?php 
			/*mobile menu border bottom color*/
			?>
			.mobile_navigation ul li
			{ border-bottom-color: <?php echo esc_html($lc_customize['mobile_border_bottom_color']); ?>; }

			<?php 
			/*album track bg color, canceled button bg color*/
			?>
			.widget_media_audio .mejs-container .mejs-controls, 
			.widget_media_video  .mejs-container .mejs-controls,
			.lnwidtget_no_featured_img, .gallery_brick_overlay,
			.single_track, .single_track .mejs-container .mejs-controls, 
			article.no_thumbnail.sticky, li.bypostauthor
			{ background-color: <?php echo esc_html($lc_customize['album_track_bg']); ?>; }

			.event_buy_btn.event_sold_out, .event_buy_btn.event_canceled,
			.lc_button.event_sold_out, .lc_button.event_sold_out:hover,
			.lc_button.event_canceled, .lc_button.event_canceled:hover
			{ 
				background-color: <?php echo esc_html($lc_customize['album_track_bg']); ?>;
				border-color: <?php echo esc_html($lc_customize['album_track_bg']); ?>; 
			}

		</style>
		<?php
	}
}

/*
	sanitize rgba colors
*/
function SLIDE_SWP_sanitize_rgba_color($color) {
	if ('' === $color ) {
		return '';
	}

	return esc_attr($color);
}

?>