<?php

define("LC_SWP_PRINT_SETTINGS", false);

function SLIDE_SWP_setup_admin_menus() {

	add_theme_page(
        'Slide Theme Settings', /* page title*/
		'Slide Theme Settings',  /* menu title */
		'administrator',    /*capability*/
        'slide_menu_page',  /*menu_slug*/
		'SLIDE_SWP_option_page_settings'  /*function */
		);		
}
add_action("admin_menu", "SLIDE_SWP_setup_admin_menus");

/*add theme settings to admin bar*/
function SLIDE_SWP_add_settings_to_adminbar($admin_bar) {
	$admin_bar->add_menu( 
		array(
        'id'    => 'slide-settings',
        'title' => esc_html__("Slide Theme Settings", "slide"),
        'href'  => admin_url( 'themes.php?page=slide_menu_page'),
        'meta'  => array(
            'title' => esc_html__("Go To Slide Settings", "slide")
        	)
    	)
	);
}
add_action('admin_bar_menu', 'SLIDE_SWP_add_settings_to_adminbar', 9990);

function SLIDE_SWP_option_page_settings() {
?>  
	<!-- Create a header in the default WordPress 'wrap' container -->  
    <div class="wrap">  
        <div id="icon-themes" class="icon32"></div>  
        <h2>Slide Theme Settings</h2>  
  
        <!-- Make a call to the WordPress function for rendering errors when settings are saved. -->  
        <?php settings_errors(); ?> 
		
		<?php  
		if(isset($_GET['tab'])) {
			$active_tab = $_GET['tab'];  
		} else {
		    $active_tab = 'general_options';
		}
		?>  		
		
		<h2 class="nav-tab-wrapper">
			<?php
				$general_options_class = $active_tab == 'general_options' ? 'nav-tab-active' : '';
				$social_options_class = $active_tab == 'social_options' ? 'nav-tab-active' : '';
				$footer_options_class = $active_tab == 'footer_options' ? 'nav-tab-active' : '';
				$contact_options_class = $active_tab == 'contact_options' ? 'nav-tab-active' : '';
				$fonts_options_class = $active_tab == 'fonts_options' ? 'nav-tab-active' : '';
			?>
			<a href="?page=slide_menu_page&tab=general_options" class="nav-tab <?php echo esc_attr($general_options_class); ?>">
				<?php echo esc_html__("General Options", 'slide'); ?>
			</a>
			<a href="?page=slide_menu_page&tab=social_options" class="nav-tab <?php echo esc_attr($social_options_class); ?>">
				<?php echo esc_html__("Social Profiles", 'slide'); ?>
			</a>
			<a href="?page=slide_menu_page&tab=footer_options" class="nav-tab <?php echo esc_attr($footer_options_class); ?>">
				<?php echo esc_html__("Footer & Side Menu", 'slide'); ?>
			</a>
			<a href="?page=slide_menu_page&tab=contact_options" class="nav-tab <?php echo esc_attr($contact_options_class); ?>">
				<?php echo esc_html__("Contact Data", 'slide'); ?>
			</a>
			<a href="?page=slide_menu_page&tab=fonts_options" class="nav-tab <?php echo esc_attr($fonts_options_class); ?>">
				<?php echo esc_html__("Fonts", 'slide'); ?>
			</a>
		</h2> 		
  
        <!-- Create the form that will be used to render our options -->  
        <form method="post" action="options.php"> 
			<?php
				if ($active_tab == 'general_options') {
					settings_fields( 'slide_theme_general_options'); 
					do_settings_sections( 'slide_theme_general_options');
				} elseif ($active_tab == 'social_options') {
					settings_fields( 'slide_theme_social_options'); 
					do_settings_sections( 'slide_theme_social_options');
				} elseif ($active_tab == 'footer_options') {
					settings_fields( 'slide_theme_footer_options'); 
					do_settings_sections( 'slide_theme_footer_options');
				} elseif ($active_tab == 'contact_options') {
					settings_fields( 'slide_theme_contact_options'); 
					do_settings_sections( 'slide_theme_contact_options');
				} elseif ($active_tab == 'fonts_options') {
					settings_fields( 'slide_theme_fonts_options'); 
					do_settings_sections( 'slide_theme_fonts_options');
				}
				submit_button(); 
			?>  
        </form>  
  
    </div><!-- /.wrap -->  
<?php 
}



/*
	Initialize theme options
*/
add_action('admin_init', 'SLIDE_SWP_initialize_theme_options');
function SLIDE_SWP_initialize_theme_options() 
{
	$lc_swp_available_theme_options = array (
		array (
			'option_name'		=> 'slide_theme_general_options',
			'section_id'		=> 'slide_general_settings_section',
			'title'				=> esc_html__('General Options', 'slide'),
			'callback'			=> 'SLIDE_SWP_general_options_callback',
			'sanitize_callback'	=> 'SLIDE_SWP_sanitize_general_options'
		),
		array (
			'option_name'		=> 'slide_theme_social_options',
			'section_id'		=> 'slide_social_settings_section',
			'title'				=> esc_html__('Social Options', 'slide'),
			'callback'			=> 'SLIDE_SWP_social_options_callback',
			'sanitize_callback'	=> 'SLIDE_SWP_sanitize_social_options'
		),
		array (
			'option_name'		=> 'slide_theme_footer_options',
			'section_id'		=> 'slide_footer_settings_section',
			'title'				=> esc_html__('Footer & Side Menu Options', 'slide'),
			'callback'			=> 'SLIDE_SWP_footer_options_callback',
			'sanitize_callback'	=> 'SLIDE_SWP_sanitize_footer_options'
		),
		array (
			'option_name'		=> 'slide_theme_contact_options',
			'section_id'		=> 'slide_contact_settings_section',
			'title'				=> esc_html__('Contact Options', 'slide'),
			'callback'			=> 'SLIDE_SWP_contact_options_callback',
			'sanitize_callback'	=> 'SLIDE_SWP_sanitize_contact_options'
		),
		array (
			'option_name'		=> 'slide_theme_fonts_options',
			'section_id'		=> 'slide_fonts_settings_section',
			'title'				=> esc_html__('Fonts Options', 'slide'),
			'callback'			=> 'SLIDE_SWP_fonts_options_callback',
			'sanitize_callback'	=> 'SLIDE_SWP_sanitize_fonts_options'
		)		
	);

	foreach($lc_swp_available_theme_options as $theme_option) {
		/*
			Add available options
		*/
		if (false == get_option($theme_option['option_name'])) {
			add_option($theme_option['option_name']);
		}

		/*
			Add setting sections
		*/
		add_settings_section (
			$theme_option['section_id'],		// ID used to identify this section and with which to register options
			$theme_option['title'],				// Title to be displayed on the administration page
			$theme_option['callback'],			// Callback used to render the description of the section
			$theme_option['option_name']		// Page on which to add this section of options
		);
	}

	/*
		call add_settings_field to add theme options
	*/
	SLIDE_SWP_add_settings_fields();

	/*
		Register settings
	*/
	foreach($lc_swp_available_theme_options as $theme_option) {
		register_setting(
			//option group - A settings group name. Must exist prior to the register_setting call. This must match the group name in settings_fields()
			$theme_option['option_name'],
			// option_name -  The name of an option to sanitize and save. 
			$theme_option['option_name'],
			//  $sanitize_callback (callback) (optional) A callback function that sanitizes the option's value
			$theme_option['sanitize_callback']  	
		);
	}
}

/*
	Callbacks that render the description for each tab
*/
function SLIDE_SWP_general_options_callback() {
?>
	<p>
		<?php echo esc_html__('Setup general theme options.', 'slide'); ?>
	</p>
<?php	
	/*print theme settings*/
	if (LC_SWP_PRINT_SETTINGS) {
		$general = get_option('slide_theme_general_options');
		
		?>
		<pre>slide_theme_general_options:
			<?php echo (json_encode($general)); ?>
		</pre>
		<?php
	}
}
 
function SLIDE_SWP_social_options_callback() {
	?>
	<p>
		<?php echo esc_html__('Provide the URL to the social profiles you would like to display.', 'slide'); ?>
	</p>
	<?php	
}

function SLIDE_SWP_footer_options_callback() {
	?> <p> <?php 
		echo esc_html__('Setup footer text for the copyright area, footer text URL and other footer related options. Also setup the footer widget area and side menu.', 'slide'); 
	?> </p> <?php
}

function SLIDE_SWP_contact_options_callback() {
	?>
	<p>
		<?php echo esc_html__('Please insert your contact information.', 'slide'); ?>
	</p>
	<?php
}

function SLIDE_SWP_fonts_options_callback() {
	?>
	<p>
		<?php echo esc_html__('Please choose the fonts.', 'slide'); ?>
	</p>
	<?php
}

/*
	Add setting fields
*/
function SLIDE_SWP_add_settings_fields() {
	/*general options array*/
	$general_settings = array (
		array (
			'id'		=> 'lc_custom_logo',
			'label'		=> esc_html__('Upload logo image', 'slide'),
			'callback'	=> 'SLIDE_SWP_logo_select_cbk'
		),
		array (
			'id'		=> 'lc_custom_innner_bg_image',
			'label'		=> esc_html__('Upload custom background image', 'slide'),
			'callback'	=> 'SLIDE_SWP_innner_bg_image_select_cbk'
		),
		array (
			'id'		=> 'lc_menu_style',
			'label'		=> esc_html__('Choose menu style', 'slide'),
			'callback'	=> 'SLIDE_SWP_menu_style_cbk'
		),/*
		array (
			'id'		=> 'lc_header_footer_width',
			'label'		=> esc_html__('Choose header/footer width', 'slide'),
			'callback'	=> 'SLIDE_SWP_header_footer_width_cbk'
		),*/
		array (
			'id'		=> 'lc_default_color_scheme',
			'label'		=> esc_html__('Choose default color scheme', 'slide'),
			'callback'	=> 'SLIDE_SWP_default_colorscheme_cbk'
		),
		array (
			'id'		=> 'lc_enable_sticky_menu',
			'label'		=> esc_html__('Enable sticky menu', 'slide'),
			'callback'	=> 'SLIDE_SWP_enable_sticky_menu_cbk'
		),
		array (
			'id'		=> 'lc_back_to_top',
			'label'		=> esc_html__('Enable back to top button', 'slide'),
			'callback'	=> 'SLIDE_SWP_back_to_top_cbk'
		),
		array (
			'id'		=> 'lc_hide_search_icon',
			'label'		=> esc_html__('Hide search icon', 'slide'),
			'callback'	=> 'SLIDE_SWP_hide_search_icon_cbk'
		),
		array (
			'id'		=> 'lc_auto_featured_image',
			'label'		=> esc_html__('Auto featured image', 'slide'),
			'callback'	=> 'SLIDE_SWP_auto_featured_image_cbk'
		),
		array (
			'id'		=> 'lc_remove_singlepost_sidebar',
			'label'		=> esc_html__('Remove sidebar on single post', 'slide'),
			'callback'	=> 'SLIDE_SWP_remove_singlepost_sidebar_cbk'
		),
		array (
			'id'		=> 'lc_remove_blog_post_meta',
			'label'		=> esc_html__('Remove posts meta from blog page', 'slide'),
			'callback'	=> 'SLIDE_SWP_remove_blog_post_meta_cbk'
		),
		array (
			'id'		=> 'lc_remove_single_blog_post_meta',
			'label'		=> esc_html__('Remove posts meta from single post', 'slide'),
			'callback'	=> 'SLIDE_SWP_remove_single_blog_post_meta_cbk'
		),		
		array (
			'id'		=> 'lc_shop_has_sidebar',
			'label'		=> esc_html__('Shop pages have sidebar', 'slide'),
			'callback'	=> 'SLIDE_SWP_shop_has_sidebar_cbk'
		),
		array (
			'id'		=> 'lc_enable_cpt_comments',
			'label'		=> esc_html__('Enable comments on custom post types', 'slide'),
			'callback'	=> 'SLIDE_SWP_lc_enable_cpt_comments_cbk'
		),
		array (
			'id'		=> 'lc_show_img_captions',
			'label'		=> esc_html__('Show image caption on hover', 'slide'),
			'callback'	=> 'SLIDE_SWP_lc_show_img_captions_cbk'
		),
		array (
			'id'		=> 'lc_show_cpt_tax',
			'label'		=> esc_html__('Show custom post types categories', 'slide'),
			'callback'	=> 'SLIDE_SWP_lc_show_cpt_tax_cbk'
		),
		array (
			'id'		=> 'lc_show_album_date',
			'label'		=> esc_html__('Show music album date as', 'slide'),
			'callback'	=> 'SLIDE_SWP_lc_show_album_date_cbk'
		),
		array (
			'id'		=> 'lc_artists_page',
			'label'		=> esc_html__('Your artists page is', 'slide'),
			'callback'	=> 'SLIDE_SWP_lc_artists_page_cbk'
		),
		array (
			'id'		=> 'lc_videos_page',
			'label'		=> esc_html__('Your videos page is', 'slide'),
			'callback'	=> 'SLIDE_SWP_lc_videos_page_cbk'
		),
		array (
			'id'		=> 'lc_gallery_page',
			'label'		=> esc_html__('Your gallery page is', 'slide'),
			'callback'	=> 'SLIDE_SWP_lc_gallery_page_cbk'
		),
		array (
			'id'		=> 'lc_albums_page',
			'label'		=> esc_html__('Your albums page is', 'slide'),
			'callback'	=> 'SLIDE_SWP_lc_albums_page_cbk'
		),
		array (
			'id'		=> 'lc_events_page',
			'label'		=> esc_html__('Your events page is', 'slide'),
			'callback'	=> 'SLIDE_SWP_lc_events_page_cbk'
		)
	);

	foreach($general_settings as $general_setting) {
	    add_settings_field(   
	        $general_setting['id'],         		// ID used to identify the field throughout the theme                
	        $general_setting['label'],              // The label to the left of the option interface element            
	        $general_setting['callback'], 			// The name of the function responsible for rendering the option interface
	        'slide_theme_general_options',   		// The page on which this option will be displayed  
	        'slide_general_settings_section'    	// The name of the section to which this field belongs  
	    );
	}

	/*social options array*/
	$social_settings = array(
		array (
			'id'		=> 'lc_fb_url',
			'label'		=> esc_html__('Facebook URL', 'slide'),
			'callback'	=> 'SLIDE_SWP_fb_url_cbk'			
		),
		array (
			'id'		=> 'lc_twitter_url',
			'label'		=> esc_html__('Twitter URL', 'slide'),
			'callback'	=> 'SLIDE_SWP_twitter_url_cbk'			
		),
		/*Google+, YouTube, Vimeo, SoundCloud, Myspace, Pinterest, iTunes*/
		array (
			'id'		=> 'lc_gplus_url',
			'label'		=> esc_html__('Google+ URL', 'slide'),
			'callback'	=> 'SLIDE_SWP_gplus_url_cbk'			
		),
		array (
			'id'		=> 'lc_youtube_url',
			'label'		=> esc_html__('YouTube URL', 'slide'),
			'callback'	=> 'SLIDE_SWP_youtube_url_cbk'			
		),
		array (
			'id'		=> 'lc_soundcloud_url',
			'label'		=> esc_html__('SoundCloud URL', 'slide'),
			'callback'	=> 'SLIDE_SWP_soundcloud_url_cbk'			
		),
		/*no font awesome icon for myspace*/
		array (
			'id'		=> 'lc_itunes_url',
			'label'		=> esc_html__('iTunes URL', 'slide'),
			'callback'	=> 'SLIDE_SWP_itunes_url_cbk'			
		),
		array (
			'id'		=> 'lc_pinterest_url',
			'label'		=> esc_html__('Pinterest URL', 'slide'),
			'callback'	=> 'SLIDE_SWP_pinterest_url_cbk'			
		),
		array (
			'id'		=> 'lc_instagram_url',
			'label'		=> esc_html__('Instagram URL', 'slide'),
			'callback'	=> 'SLIDE_SWP_instagram_url_cbk'			
		),
		array (
			'id'		=> 'lc_snapchat_url',
			'label'		=> esc_html__('Snapchat URL', 'slide'),
			'callback'	=> 'SLIDE_SWP_snapchat_url_cbk'			
		),
		array (
			'id'		=> 'lc_gplay_url',
			'label'		=> esc_html__('Google Play URL', 'slide'),
			'callback'	=> 'SLIDE_SWP_gplay_url_cbk'			
		),
		array (
			'id'		=> 'lc_linkedin_url',
			'label'		=> esc_html__('LinkedIn URL', 'slide'),
			'callback'	=> 'SLIDE_SWP_linkedin_url_cbk'			
		),
		array (
			'id'		=> 'lc_spotify_url',
			'label'		=> esc_html__('Spotify URL', 'slide'),
			'callback'	=> 'SLIDE_SWP_spotify_url_cbk'			
		),
		array (
			'id'		=> 'lc_imdb_url',
			'label'		=> esc_html__('IMDB URL', 'slide'),
			'callback'	=> 'SLIDE_SWP_imdb_url_cbk'			
		),
		array (
			'id'		=> 'lc_vimeo_url',
			'label'		=> esc_html__('Vimeo URL', 'slide'),
			'callback'	=> 'SLIDE_SWP_vimeo_url_cbk'			
		),
		array (
			'id'		=> 'lc_vk_url',
			'label'		=> esc_html__('VK URL', 'slide'),
			'callback'	=> 'SLIDE_SWP_vk_url_cbk'			
		),
		array (
			'id'		=> 'lc_amazon_music_url',
			'label'		=> esc_html__('Amazon Music URL', 'slide'),
			'callback'	=> 'SLIDE_SWP_amazon_music_url_cbk'			
		)
	);

	foreach($social_settings as $social_setting) {
	    add_settings_field(   
	        $social_setting['id'],         		// ID used to identify the field throughout the theme                
	        $social_setting['label'],              // The label to the left of the option interface element            
	        $social_setting['callback'], 			// The name of the function responsible for rendering the option interface
	        'slide_theme_social_options',   		// The page on which this option will be displayed  
	        'slide_social_settings_section'    	// The name of the section to which this field belongs  
	    );
	}

	/*footer options array*/
	$footer_settings = array(
		array(
			'id'		=> 'lc_footer_widgets_color_scheme',
			'label'		=> esc_html__('Footer widgets color scheme', 'slide'),
			'callback'	=> 'SLIDE_SWP_footer_widget_cs_cbk'		
		),
		array(
			'id'		=> 'lc_footer_widgets_background_image',
			'label'		=> esc_html__('Footer widgets Background Image', 'slide'),
			'callback'	=> 'SLIDE_SWP_footer_widget_bgimg_cbk'		
		),
		array(
			'id'		=> 'lc_footer_widgets_background_color',
			'label'		=> esc_html__('Footer widgets color overlay', 'slide'),
			'callback'	=> 'SLIDE_SWP_footer_widget_bgcolor_cbk'		
		),		
		array(
			'id'		=> 'lc_copyright_text',
			'label'		=> esc_html__('Copyright text', 'slide'),
			'callback'	=> 'SLIDE_SWP_copyright_text_cbk'		
		),
		array(
			'id'		=> 'lc_copyright_text_color',
			'label'		=> esc_html__('Copyrigth Text Color Scheme', 'slide'),
			'callback'	=> 'SLIDE_SWP_copyright_cs_cbk'		
		),
		array(
			'id'		=> 'lc_copyright_text_bg_color',
			'label'		=> esc_html__('Copyrigth Text Background Color', 'slide'),
			'callback'	=> 'SLIDE_SWP_copyright_bgc_cbk'		
		),
		array(
			'id'		=> 'lc_copyright_shows',
			'label'		=> esc_html__('Copyrigth Area Shows', 'slide'),
			'callback'	=> 'SLIDE_SWP_copyright_shows_cbk'		
		),
		array(
			'id'		=> 'lc_copyright_logo',
			'label'		=> esc_html__('Copyrigth Area Logo', 'slide'),
			'callback'	=> 'SLIDE_SWP_copyright_logo_cbk'		
		),
		array(
			'id'		=> 'lc_copyright_bg_img',
			'label'		=> esc_html__('Copyrigth Area Background Image', 'slide'),
			'callback'	=> 'SLIDE_SWP_copyright_bg_img'
		),		
		array(
			'id'		=> 'lc_side_menu_bg_color',
			'label'		=> esc_html__('Side Menu Background Color', 'slide'),
			'callback'	=> 'SLIDE_SWP_side_menu_bgc_cbk'		
		),
		array(
			'id'		=> 'lc_side_menu_cs',
			'label'		=> esc_html__('Side Menu Text Color Scheme', 'slide'),
			'callback'	=> 'SLIDE_SWP_side_menu_cs_cbk'		
		),		
	);
	foreach($footer_settings as $footer_setting) {
	    add_settings_field(   
	        $footer_setting['id'],         		// ID used to identify the field throughout the theme                
	        $footer_setting['label'],              // The label to the left of the option interface element            
	        $footer_setting['callback'], 			// The name of the function responsible for rendering the option interface
	        'slide_theme_footer_options',   		// The page on which this option will be displayed  
	        'slide_footer_settings_section'    	// The name of the section to which this field belongs  
	    );
	}

	/*contact options array*/
	$contact_settings = array(
		array(
			'id'		=> 'lc_contact_address',
			'label'		=> esc_html__('Contact address', 'slide'),
			'callback'	=> 'SLIDE_SWP_lc_contact_address_cbk'		
		),
		array(
			'id'		=> 'lc_contact_phone',
			'label'		=> esc_html__('Contact phone', 'slide'),
			'callback'	=> 'SLIDE_SWP_lc_contact_phone_cbk'		
		),
		array(
			'id'		=> 'lc_contact_phone2',
			'label'		=> esc_html__('Second contact phone', 'slide'),
			'callback'	=> 'SLIDE_SWP_lc_contact_phone2_cbk'		
		),

		array(
			'id'		=> 'lc_contact_fax',
			'label'		=> esc_html__('Contact Fax Number', 'slide'),
			'callback'	=> 'SLIDE_SWP_lc_contact_fax_cbk'		
		),
		array(
			'id'		=> 'lc_contact_email',
			'label'		=> esc_html__('Contact E-mail', 'slide'),
			'callback'	=> 'SLIDE_SWP_lc_contact_email_cbk'		
		)	
	);

	foreach($contact_settings as $contact_setting) {
	    add_settings_field(   
	        $contact_setting['id'],         		// ID used to identify the field throughout the theme                
	        $contact_setting['label'],              // The label to the left of the option interface element            
	        $contact_setting['callback'], 			// The name of the function responsible for rendering the option interface
	        'slide_theme_contact_options',   		// The page on which this option will be displayed  
	        'slide_contact_settings_section'    	// The name of the section to which this field belongs  
	    );
	}

	/*fonts options array*/
	$fonts_settings = array(
		array(
			'id'		=> 'lc_fonts_custom_default',
			'label'		=> esc_html__('Fonts in use', 'slide'),
			'callback'	=> 'SLIDE_SWP_lc_fonts_custom_default_cbk'		
		),
		array(
			'id'		=> 'lc_primary_font',
			'label'		=> esc_html__('Primary font', 'slide'),
			'callback'	=> 'SLIDE_SWP_lc_primary_font_cbk'
		),
		array(
			'id'		=> 'lc_secondary_font',
			'label'		=> esc_html__('Secondary font', 'slide'),
			'callback'	=> 'SLIDE_SWP_lc_secondary_font_cbk'		
		)
	);

	foreach($fonts_settings as $font_setting) {
	    add_settings_field(   
	        $font_setting['id'],         		// ID used to identify the field throughout the theme                
	        $font_setting['label'],              // The label to the left of the option interface element            
	        $font_setting['callback'], 			// The name of the function responsible for rendering the option interface
	        'slide_theme_fonts_options',   		// The page on which this option will be displayed  
	        'slide_fonts_settings_section'    	// The name of the section to which this field belongs  
	    );
	}	
}



/*
	Sanitize Functions
*/
function  SLIDE_SWP_sanitize_general_options($input) {
	$output = array();

	foreach($input as $key => $val) {
		if(isset($input[$key])) {
			if ($key == 'lc_custom_logo') {
				$output[$key] = esc_url_raw(trim( $input[$key] ) );
			} else {
				$output[$key] =  esc_html(trim($input[$key])) ;	
			}
		}
	}

	return apply_filters('SLIDE_SWP_sanitize_general_options', $output, $input);
}

function SLIDE_SWP_sanitize_social_options($input) {
	$output = array();

	foreach($input as $key => $val) {
		if(isset($input[$key])) {
			$output[$key] =  esc_url_raw(trim($input[$key])) ;
		}
	}

	return apply_filters('SLIDE_SWP_sanitize_social_options', $output, $input);
}

function SLIDE_SWP_sanitize_footer_options($input) {
	$output = array();

	foreach($input as $key => $val) {
		if(isset($input[$key])) {
			switch($key) {
				case 'lc_footer_widgets_background_image':
					$output[$key] =  esc_url_raw(trim($input[$key]));
					break;
				case 'lc_copyright_text':
					$allowed_html = array(
						'a'	=> array(
							"href"		=> array(),
							"target"	=> array()
							)
					);
					$output[$key] =  wp_kses(trim($input[$key]), $allowed_html);
				default:
					$output[$key] =  esc_html(trim($input[$key]));
					break;
			}
		}
	}

	return apply_filters('SLIDE_SWP_sanitize_footer_options', $output, $input);
}

function SLIDE_SWP_sanitize_contact_options($input) {
	$output = array();

	foreach($input as $key => $val) {
		if(isset($input[$key])) {
			if ($key == 'lc_contact_email') {
				$output[$key] = sanitize_email(trim($input[$key]));	
			} else {
				$output[$key] =  esc_html(trim($input[$key]));	
			}
		}
	}

	return apply_filters('SLIDE_SWP_sanitize_contact_options', $output, $input);
}

function SLIDE_SWP_sanitize_fonts_options($input) {
	$output = array();

	foreach($input as $key => $val) {
		if(isset($input[$key])) {
			$output[$key] =  esc_html(trim($input[$key]));	
		}
	}

	return apply_filters('SLIDE_SWP_sanitize_fonts_options', $output, $input);
}

/*
	CALLBACKS FOR SETTINGS FIELDS
*/
function SLIDE_SWP_logo_select_cbk() {
	$logo_url = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_custom_logo');

?>
	<input id="lc_swp_logo_upload_value" type="text" name="slide_theme_general_options[lc_custom_logo]" size="150" value="<?php echo esc_url($logo_url); ?>"/>
	<input id="lc_swp_upload_logo_button" type="button" class="button" value="<?php echo esc_html__('Upload Logo', 'slide'); ?>" />
	<input id="lc_swp_remove_logo_button" type="button" class="button" value="<?php echo esc_html__('Remove Logo', 'slide'); ?>" />
	<p class="description">
		<?php echo esc_html__('Upload a custom logo image.', 'slide'); ?>
	</p>

	<div id="lc_logo_image_preview">
		<img class="lc_swp_setting_preview_logo" src="<?php echo esc_url($logo_url); ?>">
	</div>

<?php
}

function SLIDE_SWP_innner_bg_image_select_cbk() {
	$inner_bg_img_url = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_custom_innner_bg_image');
?>

	<input id="lc_swp_innner_bg_image_upload_value" type="text" name="slide_theme_general_options[lc_custom_innner_bg_image]" size="150" value="<?php echo esc_url($inner_bg_img_url); ?>"/>
	<input id="lc_swp_upload_innner_bg_image_button" type="button" class="button" value="<?php echo esc_html__('Upload Image', 'slide'); ?>" />
	<input id="lc_swp_remove_innner_bg_image_button" type="button" class="button" value="<?php echo esc_html__('Remove Image', 'slide'); ?>" />
	<p class="description">
		<?php echo esc_html__('Upload a custom background image for inner pages. Can be overwritten by page specific settings, that can be found under the content area.', 'slide'); ?>
	</p>

	<div id="lc_innner_bg_image_preview">
		<img class="lc_swp_setting_preview_favicon" src="<?php echo esc_url($inner_bg_img_url); ?>">
	</div>	
<?php	
}

function SLIDE_SWP_menu_style_cbk() {
	$menu_style = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_menu_style');
	if (empty($menu_style)) {
		$menu_style = 'centered_menu';
	}

	$menu_options = array(
		esc_html__('Menu Centered', 'slide')				=> 'centered_menu',
		esc_html__('Logo Centered', 'slide')				=> 'centered_logo',		
		esc_html__('Menu Left', 'slide')					=> 'classic_menu'
	);
?>

	<select id="lc_menu_style" class="swp_new_settings_section" name="slide_theme_general_options[lc_menu_style]">
		<?php SLIDE_SWP_render_select_options($menu_options, $menu_style); ?>
	</select>
<?php	
}

function SLIDE_SWP_header_footer_width_cbk() {
	$header_width = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_header_footer_width');
	if (empty($header_width)) {
		$header_width = 'full';
	}

	$width_options = array(
		'Full Width'	=> 'full',
		'Boxed Width'	=> 'boxed'
	);
?>
	<select id="lc_header_footer_width" name="slide_theme_general_options[lc_header_footer_width]">
		<?php SLIDE_SWP_render_select_options($width_options, $header_width); ?>
	</select>
<?php
}

function SLIDE_SWP_default_colorscheme_cbk() {
	$color_scheme = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_default_color_scheme');
	if (empty($color_scheme)) {
		$color_scheme = 'white_on_black';
	}

	$color_schemes = array(
		esc_html__('White On Black', 'slide')	=> 'white_on_black',
		esc_html__('Black on White', 'slide')	=> 'black_on_white'
	);
?>

	<select id="lc_default_color_scheme" name="slide_theme_general_options[lc_default_color_scheme]" class="swp_new_settings_section">
		<?php SLIDE_SWP_render_select_options($color_schemes, $color_scheme); ?>
	</select>
	<p class="description">
		<?php echo esc_html__('Default color scheme used for the website content.', 'slide').'<br>'; ?>
		<?php echo esc_html__('Black On White - black text on white background.', 'slide'); ?>
		<?php echo esc_html__('White On Black - white text on black background.', 'slide').'<br>'; ?>
		<?php echo esc_html__('If you change this value, you might need to change the background color or image for your website according to the color scheme.', 'slide'); ?>
		<?php echo esc_html__('You can change the background color for your website from Appearance - Customize - Colors.', 'slide'); ?>
	</p>
<?php	
}

function SLIDE_SWP_enable_sticky_menu_cbk() {
	$sticky_menu = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_enable_sticky_menu');

	if (empty($sticky_menu)) {
		$sticky_menu = 'enabled';
	}

	$sticky_options = array(
		esc_html__('Enabled', 'slide')	=> 'enabled',
		esc_html__('Disabled', 'slide')	=> 'disabled'
	);
?>
	<select id="lc_enable_sticky_menu" name="slide_theme_general_options[lc_enable_sticky_menu]" class="swp_new_settings_section">
		<?php SLIDE_SWP_render_select_options($sticky_options, $sticky_menu); ?>
	</select>
	<p class="description">
		<?php echo esc_html__('Enable or disable sticky menu bar. If enabled, menu will stay on top whyle the user moves the scrollbar.', 'slide'); ?>
	</p>
<?php
}


function SLIDE_SWP_back_to_top_cbk() {
	$back_to_top = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_back_to_top');

	if (empty($back_to_top)) {
		$back_to_top = 'disabled';
	}

	$sticky_options = array(
		esc_html__('Enabled', 'slide')	=> 'enabled',
		esc_html__('Disabled', 'slide')	=> 'disabled'
	);
?>
	<select id="lc_back_to_top" name="slide_theme_general_options[lc_back_to_top]">
		<?php SLIDE_SWP_render_select_options($sticky_options, $back_to_top); ?>
	</select>
	<p class="description">
		<?php echo esc_html__('Enable or disable back to top button.', 'slide'); ?>
	</p>
<?php
}

function SLIDE_SWP_hide_search_icon_cbk() {
	$hide_icon = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_hide_search_icon');

	if (empty($hide_icon)) {
		$hide_icon = 'enabled';
	}

	$hide_options = array(
		esc_html__('Enabled - Hide Icon', 'slide')	=> 'enabled',
		esc_html__('Disabled - Keep Icon', 'slide')	=> 'disabled'
	);
?>
	<select id="lc_hide_search_icon" name="slide_theme_general_options[lc_hide_search_icon]">
		<?php SLIDE_SWP_render_select_options($hide_options, $hide_icon); ?>
	</select>
	<p class="description">
		<?php echo esc_html__('Hide search icon on menu.', 'slide'); ?>
	</p>
<?php
}

function SLIDE_SWP_auto_featured_image_cbk() {
	$auto_featured_image = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_auto_featured_image');

	if (empty($auto_featured_image)) {
		$auto_featured_image = 'enabled';
	}

	$auto_featured_options = array(
		esc_html__('Enabled - Auto Featured Image', 'slide')	=> 'enabled',
		esc_html__('Disabled - Manually Featured Image', 'slide')	=> 'disabled'
		
	);
?>
	<select id="lc_auto_featured_image" name="slide_theme_general_options[lc_auto_featured_image]">
		<?php SLIDE_SWP_render_select_options($auto_featured_options, $auto_featured_image); ?>
	</select>
	<p class="description">
		<?php echo esc_html__('Automatically show featured image at the beginning of the single post content.', 'slide'); ?>
	</p>
<?php	
}

function SLIDE_SWP_remove_singlepost_sidebar_cbk() {
	$remove_singlepost_sidebar = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_remove_singlepost_sidebar');

	if (empty($remove_singlepost_sidebar)) {
		$remove_singlepost_sidebar = 'disabled';
	}

	$remove_sidebar_options = array(
		esc_html__('Disabled - Keep Sidebar', 'slide')	=> 'disabled',
		esc_html__('Enabled - Remove Sidebar', 'slide')	=> 'enabled'
	);
?>
	<select id="lc_remove_singlepost_sidebar" name="slide_theme_general_options[lc_remove_singlepost_sidebar]">
		<?php SLIDE_SWP_render_select_options($remove_sidebar_options, $remove_singlepost_sidebar); ?>
	</select>
	<p class="description">
		<?php echo esc_html__('Choose to remove sidebar on single post.', 'slide'); ?>
	</p>
<?php
}

function SLIDE_SWP_remove_blog_post_meta_cbk() {
	$remove_blog_post_meta = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_remove_blog_post_meta');

	if (empty($remove_blog_post_meta)) {
		$remove_blog_post_meta = 'disabled';
	}

	$remove_meta_options = array(
		esc_html__('Disabled - Keep Posts Meta', 'slide')	=> 'disabled',
		esc_html__('Enabled - Remove Posts Meta', 'slide')	=> 'enabled'
	);
?>
	<select id="lc_remove_blog_post_meta" name="slide_theme_general_options[lc_remove_blog_post_meta]">
		<?php SLIDE_SWP_render_select_options($remove_meta_options, $remove_blog_post_meta); ?>
	</select>
	<p class="description">
		<?php echo esc_html__('Choose to remove post meta from posts on blog page template and on visual composer blog element.', 'slide'); ?>
		<?php echo esc_html__('Elements removed are: post author, post date and post category.', 'slide'); ?>
	</p>
<?php
}

function SLIDE_SWP_remove_single_blog_post_meta_cbk() {
	$remove_single_blog_post_meta = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_remove_single_blog_post_meta');

	if (empty($remove_single_blog_post_meta)) {
		$remove_single_blog_post_meta = 'disabled';
	}

	$remove_meta_options = array(
		esc_html__('Disabled - Keep Posts Meta', 'slide')	=> 'disabled',
		esc_html__('Enabled - Remove Posts Meta', 'slide')	=> 'enabled'
	);
?>
	<select id="lc_remove_single_blog_post_meta" name="slide_theme_general_options[lc_remove_single_blog_post_meta]">
		<?php SLIDE_SWP_render_select_options($remove_meta_options, $remove_single_blog_post_meta); ?>
	</select>
	<p class="description">
		<?php echo esc_html__('Choose to remove post meta from single posts.', 'slide'); ?>
		<?php echo esc_html__('Elements removed are: post author, post date and post category.', 'slide'); ?>
	</p>
<?php
}

function SLIDE_SWP_shop_has_sidebar_cbk() {
	$shop_has_sidebar = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_shop_has_sidebar');

	if (empty($shop_has_sidebar)) {
		$shop_has_sidebar = 'disabled';
	}

	$shop_has_sidebar_options = array(
		esc_html__('Disabled - No Sidebar', 'slide')	=> 'disabled',
		esc_html__('Enabled - Have Sidebar', 'slide')	=> 'enabled'
	);
?>
	<select id="lc_shop_has_sidebar" name="slide_theme_general_options[lc_shop_has_sidebar]">
		<?php SLIDE_SWP_render_select_options($shop_has_sidebar_options, $shop_has_sidebar); ?>
	</select>
	<p class="description">
		<?php echo esc_html__('Choose to add sidebar to WooCommerce pages. Applies to shop, product category, product tag and single product pages.', 'slide'); ?>
	</p>
<?php
}

function SLIDE_SWP_lc_enable_cpt_comments_cbk() {
	$enable_cpt_comments = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_enable_cpt_comments');

	if (empty($enable_cpt_comments)) {
		$enable_cpt_comments = 'disabled';
	}

	$enable_cpt_comments_opts = array(
		esc_html__('Disabled - No Comments', 'slide')	=> 'disabled',
		esc_html__('Enabled - Have Comments', 'slide')	=> 'enabled'
	);
?>
	<select id="lc_enable_cpt_comments" name="slide_theme_general_options[lc_enable_cpt_comments]">
		<?php SLIDE_SWP_render_select_options($enable_cpt_comments_opts, $enable_cpt_comments); ?>
	</select>
	<p class="description">
		<?php echo esc_html__('Choose to enable comments at the end of event, album, gallery and video post.', 'slide'); ?>
	</p>
<?php
}

function SLIDE_SWP_lc_show_img_captions_cbk() {
	$show_img_caption = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_show_img_caption');

	if (empty($show_img_caption)) {
		$show_img_caption = 'disabled';
	}

	$show_img_caption_opts = array(
		esc_html__('Disabled - No Caption', 'slide')	=> 'disabled',
		esc_html__('Enabled - Show Caption', 'slide')	=> 'enabled'
	);
?>
	<select id="lc_show_img_caption" name="slide_theme_general_options[lc_show_img_caption]">
		<?php SLIDE_SWP_render_select_options($show_img_caption_opts, $show_img_caption); ?>
	</select>
	<p class="description">
		<?php echo esc_html__('Show image caption on hover - available for single photo gallery page.', 'slide'); ?>
	</p>
<?php	
}

function SLIDE_SWP_lc_show_cpt_tax_cbk() {
	$show_cpt_tax = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_show_cpt_tax');

	if (empty($show_cpt_tax)) {
		$show_cpt_tax = 'disabled';
	}

	$show_cpt_tax_opts = array(
		esc_html__('Disabled - No Categories', 'slide')	=> 'disabled',
		esc_html__('Enabled - Show Categories', 'slide')	=> 'enabled'
	);
?>
	<select id="lc_show_cpt_tax" name="slide_theme_general_options[lc_show_cpt_tax]">
		<?php SLIDE_SWP_render_select_options($show_cpt_tax_opts, $show_cpt_tax); ?>
	</select>
	<p class="description">
		<?php echo esc_html__('Show custom post types categories on top of archive pages like Videos/Discography/Events/Photo Albums.', 'slide'); ?>
	</p>
<?php
}

function SLIDE_SWP_lc_show_album_date_cbk() {
	$show_album_date = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_show_album_date');

	if (empty($show_album_date)) {
		$show_album_date = 'full_date';
	}

	$show_album_date_opts = array(
		esc_html__('Full Date', 'slide')	=> 'full_date',
		esc_html__('Year Only', 'slide')	=> 'year'
	);
?>
	<select id="lc_show_album_date" name="slide_theme_general_options[lc_show_album_date]">
		<?php SLIDE_SWP_render_select_options($show_album_date_opts, $show_album_date); ?>
	</select>
	<p class="description">
		<?php echo esc_html__('Choose to show only the year part for the music album date.', 'slide'); ?>
	</p>
<?php
}

function SLIDE_SWP_lc_artists_page_cbk() {
	$artist_page = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_artists_page');
	if (empty($artist_page)) {
		$artist_page = 'not_set';
	}

	$pages = SLIDE_SWP_get_pages_by_template("template-artists.php");

?>
	<select id="lc_artists_page" name="slide_theme_general_options[lc_artists_page]" class="swp_new_settings_section">
		<?php SLIDE_SWP_render_select_options($pages, $artist_page); ?>
	</select>

	<p class="description">
		<?php echo esc_html__('Choose the page used as artists page.', 'slide'); ?>
	</p>
<?php	
}
function SLIDE_SWP_lc_videos_page_cbk() {
	$videos_page = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_videos_page');
	if (empty($videos_page)) {
		$videos_page = 'not_set';
	}

	$pages = SLIDE_SWP_get_pages_by_template("template-videos.php");

?>
	<select id="lc_videos_page" name="slide_theme_general_options[lc_videos_page]">
		<?php SLIDE_SWP_render_select_options($pages, $videos_page); ?>
	</select>

	<p class="description">
		<?php echo esc_html__('Choose the page used as videos page.', 'slide'); ?>
	</p>
<?php	
}

function SLIDE_SWP_lc_gallery_page_cbk() {
	$gallery_page = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_gallery_page');
	if (empty($gallery_page)) {
		$gallery_page = 'not_set';
	}

	$pages = SLIDE_SWP_get_pages_by_template("template-photo-gallery.php");

?>
	<select id="lc_gallery_page" name="slide_theme_general_options[lc_gallery_page]">
		<?php SLIDE_SWP_render_select_options($pages, $gallery_page); ?>
	</select>

	<p class="description">
		<?php echo esc_html__('Choose the page used as gallery page.', 'slide'); ?>
	</p>
<?php	
}

function SLIDE_SWP_lc_albums_page_cbk() {
	$albums_page = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_albums_page');
	if (empty($albums_page)) {
		$albums_page = 'not_set';
	}

	$pages = SLIDE_SWP_get_pages_by_template("template-discography.php");

?>
	<select id="lc_albums_page" name="slide_theme_general_options[lc_albums_page]">
		<?php SLIDE_SWP_render_select_options($pages, $albums_page); ?>
	</select>

	<p class="description">
		<?php echo esc_html__('Choose the page used as albums page.', 'slide'); ?>
	</p>
<?php
}

function SLIDE_SWP_lc_events_page_cbk() {
	$events_page = SLIDE_SWP_get_theme_option('slide_theme_general_options', 'lc_events_page');
	if (empty($events_page)) {
		$events_page = 'not_set';
	}

	$pages = SLIDE_SWP_get_pages_by_template("template-events-upcoming.php");

?>
	<select id="lc_events_page" name="slide_theme_general_options[lc_events_page]">
		<?php SLIDE_SWP_render_select_options($pages, $events_page); ?>
	</select>

	<p class="description">
		<?php echo esc_html__('Choose the page used as events page.', 'slide'); ?>
	</p>
<?php
}


/*
	Social Options
*/
function SLIDE_SWP_fb_url_cbk() {
	$fb_url = SLIDE_SWP_get_theme_option('slide_theme_social_options', 'lc_fb_url');

?>
	<input id="lc_fb_url" type="text" name="slide_theme_social_options[lc_fb_url]" size="150" value="<?php echo esc_url($fb_url); ?>"/>
<?php
}

function SLIDE_SWP_twitter_url_cbk() {
	$twitter_url = SLIDE_SWP_get_theme_option('slide_theme_social_options', 'lc_twitter_url');

?>
	<input id="lc_twitter_url" type="text" name="slide_theme_social_options[lc_twitter_url]" size="150" value="<?php echo esc_url($twitter_url); ?>"/>
<?php
}

function SLIDE_SWP_gplus_url_cbk() {
	$gplus_url = SLIDE_SWP_get_theme_option('slide_theme_social_options', 'lc_gplus_url');

?>
	<input id="lc_gplus_url" type="text" name="slide_theme_social_options[lc_gplus_url]" size="150" value="<?php echo esc_url($gplus_url); ?>"/>
<?php
}

function SLIDE_SWP_youtube_url_cbk() {
	$youtube_url = SLIDE_SWP_get_theme_option('slide_theme_social_options', 'lc_youtube_url');

?>
	<input id="lc_youtube_url" type="text" name="slide_theme_social_options[lc_youtube_url]" size="150" value="<?php echo esc_url($youtube_url); ?>"/>
<?php
}

function SLIDE_SWP_soundcloud_url_cbk() {
	$soundcloud_url = SLIDE_SWP_get_theme_option('slide_theme_social_options', 'lc_soundcloud_url');

?>
	<input id="lc_soundcloud_url" type="text" name="slide_theme_social_options[lc_soundcloud_url]" size="150" value="<?php echo esc_url($soundcloud_url); ?>"/>
<?php
}

function SLIDE_SWP_myspace_url_cbk() {
	$myspace_url = SLIDE_SWP_get_theme_option('slide_theme_social_options', 'lc_myspace_url');

?>
	<input id="lc_myspace_url" type="text" name="slide_theme_social_options[lc_myspace_url]" size="150" value="<?php echo esc_url($myspace_url); ?>"/>
<?php
}

function SLIDE_SWP_itunes_url_cbk() {
	$itunes_url = SLIDE_SWP_get_theme_option('slide_theme_social_options', 'lc_itunes_url');

?>
	<input id="lc_itunes_url" type="text" name="slide_theme_social_options[lc_itunes_url]" size="150" value="<?php echo esc_url($itunes_url); ?>"/>
<?php
}

function SLIDE_SWP_pinterest_url_cbk() {
	$pinterest_url = SLIDE_SWP_get_theme_option('slide_theme_social_options', 'lc_pinterest_url');

?>
	<input id="lc_pinterest_url" type="text" name="slide_theme_social_options[lc_pinterest_url]" size="150" value="<?php echo esc_url($pinterest_url); ?>"/>
<?php
}

function SLIDE_SWP_instagram_url_cbk() {
	$instagram_url = SLIDE_SWP_get_theme_option('slide_theme_social_options', 'lc_instagram_url');

?>
	<input id="lc_instagram_url" type="text" name="slide_theme_social_options[lc_instagram_url]" size="150" value="<?php echo esc_url($instagram_url); ?>"/>
<?php
}

function SLIDE_SWP_snapchat_url_cbk() {
	$snapchat_url = SLIDE_SWP_get_theme_option('slide_theme_social_options', 'lc_snapchat_url');

?>
	<input id="lc_snapchat_url" type="text" name="slide_theme_social_options[lc_snapchat_url]" size="150" value="<?php echo esc_url($snapchat_url); ?>"/>
<?php
}

function SLIDE_SWP_gplay_url_cbk() {
	$gplay_url = SLIDE_SWP_get_theme_option('slide_theme_social_options', 'lc_gplay_url');

?>
	<input id="lc_gplay_url" type="text" name="slide_theme_social_options[lc_gplay_url]" size="150" value="<?php echo esc_url($gplay_url); ?>"/>
<?php
}

function SLIDE_SWP_linkedin_url_cbk() {
	$linkedin_url = SLIDE_SWP_get_theme_option('slide_theme_social_options', 'lc_linkedin_url');

?>
	<input id="lc_linkedin_url" type="text" name="slide_theme_social_options[lc_linkedin_url]" size="150" value="<?php echo esc_url($linkedin_url); ?>"/>
<?php
}

function SLIDE_SWP_spotify_url_cbk() {
	$spotify_url = SLIDE_SWP_get_theme_option('slide_theme_social_options', 'lc_spotify_url');

?>
	<input id="lc_spotify_url" type="text" name="slide_theme_social_options[lc_spotify_url]" size="150" value="<?php echo esc_url($spotify_url); ?>"/>
<?php
}

function SLIDE_SWP_imdb_url_cbk() {
	$imdb_url = SLIDE_SWP_get_theme_option('slide_theme_social_options', 'lc_imdb_url');

?>
	<input id="lc_imdb_url" type="text" name="slide_theme_social_options[lc_imdb_url]" size="150" value="<?php echo esc_url($imdb_url); ?>"/>
<?php
}

function SLIDE_SWP_vimeo_url_cbk() {
	$vimeo_url = SLIDE_SWP_get_theme_option('slide_theme_social_options', 'lc_vimeo_url');

?>
	<input id="lc_vimeo_url" type="text" name="slide_theme_social_options[lc_vimeo_url]" size="150" value="<?php echo esc_url($vimeo_url); ?>"/>
<?php
}

function SLIDE_SWP_vk_url_cbk() {
	$vk_url = SLIDE_SWP_get_theme_option('slide_theme_social_options', 'lc_vk_url');

?>
	<input id="lc_vk_url" type="text" name="slide_theme_social_options[lc_vk_url]" size="150" value="<?php echo esc_url($vk_url); ?>"/>
<?php
}

function SLIDE_SWP_amazon_music_url_cbk() {
	$amazon_music_url = SLIDE_SWP_get_theme_option('slide_theme_social_options', 'lc_amazon_music_url');

?>
	<input id="lc_amazon_music_url" type="text" name="slide_theme_social_options[lc_amazon_music_url]" size="150" value="<?php echo esc_url($amazon_music_url); ?>"/>
<?php	
}


/*
	Footer Options
*/

function SLIDE_SWP_footer_widget_cs_cbk() {
	$footer_color_scheme = SLIDE_SWP_get_theme_option('slide_theme_footer_options', 'lc_footer_widgets_color_scheme');
	if (empty($footer_color_scheme)) {
		$footer_color_scheme = 'white_on_black';
	}

	$footer_color_schemes = array(
		esc_html__('White On Black', 'slide')	=> 'white_on_black',
		esc_html__('Black on White', 'slide')	=> 'black_on_white'
	);
?>

	<select id="lc_footer_widgets_color_scheme" name="slide_theme_footer_options[lc_footer_widgets_color_scheme]">
		<?php SLIDE_SWP_render_select_options($footer_color_schemes, $footer_color_scheme); ?>
	</select>
	<p class="description">
		<?php echo esc_html__('Color scheme used for footer widgets text.', 'slide'); ?>
	</p>
<?php
}

function SLIDE_SWP_footer_widget_bgimg_cbk() {
	$footer_bg_image = SLIDE_SWP_get_theme_option('slide_theme_footer_options', 'lc_footer_widgets_background_image');

?>
	<input id="lc_swp_footer_bg_image_upload_value" type="text" name="slide_theme_footer_options[lc_footer_widgets_background_image]" size="150" value="<?php echo esc_url($footer_bg_image); ?>"/>
	<input id="lc_swp_upload_footer_widgets_bg_image_button" type="button" class="button" value="<?php echo esc_html__('Upload Image', 'slide'); ?>" />
	<input id="lc_swp_remove_footer_widgets_bg_image_button" type="button" class="button" value="<?php echo esc_html__('Remove Image', 'slide'); ?>" />
	<p class="description">
		<?php echo esc_html__('Upload a custom background image for the footer widgets area.', 'slide'); ?>
	</p>

	<div id="lc_footer_widgets_bg_image_preview">
		<img class="lc_swp_setting_preview_favicon" src="<?php echo esc_url($footer_bg_image); ?>">
	</div>
<?php
}

function SLIDE_SWP_footer_widget_bgcolor_cbk() {
	$footer_background_color = SLIDE_SWP_get_theme_option('slide_theme_footer_options', 'lc_footer_widgets_background_color');
	$default_bg_color = 'rgba(21, 23, 39,1)';

	if ('' == $footer_background_color) {
		$footer_background_color = $default_bg_color;
	}
?>

	<input type="text" id="lc_footer_widgets_background_color" class="alpha-color-picker-settings" name="slide_theme_footer_options[lc_footer_widgets_background_color]" value="<?php echo esc_attr($footer_background_color); ?>" data-default-color="rgba(21, 23, 39,1)" data-show-opacity="true" />

	<p class="description">
		<?php echo esc_html__('Color overlay for the footer widgets area. Can be used as background color or as color over the background image.', 'slide'); ?>
	</p>
<?php	
}

function SLIDE_SWP_copyright_text_cbk() {
	$copyright_text = SLIDE_SWP_get_theme_option('slide_theme_footer_options', 'lc_copyright_text');
?>
	<textarea class="swp_new_settings_section" cols="147" rows="10" id="lc_copyright_text" name="slide_theme_footer_options[lc_copyright_text]" ><?php echo esc_html($copyright_text); ?></textarea>;
	
	<p class="description">
		<?php echo esc_html__('Insert the copyright text that is shown at the bottom of your pages. Links are allowed', 'slide'); ?>
	</p>	

<?php
}

function SLIDE_SWP_copyright_cs_cbk() {
	$copy_color_scheme = SLIDE_SWP_get_theme_option('slide_theme_footer_options', 'lc_copyright_text_color');
	if (empty($copy_color_scheme)) {
		$copy_color_scheme = 'white_on_black';
	}

	$copy_color_schemes = array(
		esc_html__('White On Black', 'slide')	=> 'white_on_black',
		esc_html__('Black on White', 'slide')	=> 'black_on_white'
	);
?>

	<select id="lc_copyright_text_color" name="slide_theme_footer_options[lc_copyright_text_color]">
		<?php SLIDE_SWP_render_select_options($copy_color_schemes, $copy_color_scheme); ?>
	</select>

	<p class="description">
		<?php echo esc_html__('Color scheme used for footer copyrigth text.', 'slide'); ?>
	</p>
<?php
}

function SLIDE_SWP_copyright_bgc_cbk() {
	$copy_bgc = SLIDE_SWP_get_theme_option('slide_theme_footer_options', 'lc_copyright_text_bg_color');
	$default_copy_bgc = 'rgba(29,31,49,1)';

	if ('' == $copy_bgc) {
		$copy_bgc = $default_copy_bgc;
	}
?>

	<input type="text" id="lc_copyright_text_bg_color" class="alpha-color-picker-settings" name="slide_theme_footer_options[lc_copyright_text_bg_color]" value="<?php echo esc_html($copy_bgc); ?>" data-default-color="rgba(29,31,49,1)" data-show-opacity="true" />

	<p class="description">
		<?php echo esc_html__('Background color for the copyright text area.', 'slide'); ?>
	</p>
<?php	
}

function SLIDE_SWP_copyright_shows_cbk() {
	$copyright_shows = SLIDE_SWP_get_theme_option('slide_theme_footer_options', 'lc_copyright_shows');
	if (empty($copyright_shows)) {
		$copyright_shows = 'copy_text_only';
	}

	$copy_shows_support = array(
		esc_html__('Copyright Text Only', 'slide')	=> 'copy_text_only',
		esc_html__('Copyright Text, Logo, Social Icons', 'slide')	=> 'text_logo_social',
		esc_html__('Email, Menu, Icons, Logo', 'slide')	=> 'email_menu_icons_logo',
		esc_html__('Logo, Menu, Copyright Text', 'slide')	=> 'logo_menu_text'
	);
?>
	<select id="lc_copyright_shows" name="slide_theme_footer_options[lc_copyright_shows]">
		<?php SLIDE_SWP_render_select_options($copy_shows_support, $copyright_shows); ?>
	</select>

	<p class="description">
		<?php echo esc_html__('Choose what to show at the bottom of your website. ', 'slide'); ?>
		<?php echo esc_html__('If you want to show a menu on the footer area, please go to Appearance - Menus and create and assign the menu to the footer area. ', 'slide'); ?>
	</p>
<?php
}

function SLIDE_SWP_copyright_logo_cbk() {
	$lc_copyright_logo = SLIDE_SWP_get_theme_option('slide_theme_footer_options', 'lc_copyright_logo');

?>
	<input id="lc_swp_copyright_logo_upload_value" type="text" name="slide_theme_footer_options[lc_copyright_logo]" size="150" value="<?php echo esc_url($lc_copyright_logo); ?>"/>
	<input id="lc_swp_upload_copyright_logo_button" type="button" class="button" value="<?php echo esc_html__('Upload Logo', 'slide'); ?>" />
	<input id="lc_swp_remove_copyright_logo_button" type="button" class="button" value="<?php echo esc_html__('Remove Logo', 'slide'); ?>" />
	<p class="description">
		<?php echo esc_html__('Upload a logo image for the footer copyright area.', 'slide'); ?>
	</p>

	<div id="lc_footer_copyright_logo_preview">
		<img class="lc_swp_copyright_logo_preview" src="<?php echo esc_url($lc_copyright_logo); ?>">
	</div>
<?php	
}

function SLIDE_SWP_copyright_bg_img() {
	$lc_copyright_bg_img = SLIDE_SWP_get_theme_option('slide_theme_footer_options', 'lc_copyright_bg_img');

?>
	<input id="lc_swp_copyright_bg_img_upload_value" type="text" name="slide_theme_footer_options[lc_copyright_bg_img]" size="150" value="<?php echo esc_url($lc_copyright_bg_img); ?>"/>
	<input id="lc_swp_upload_copyright_bg_img_button" type="button" class="button" value="<?php echo esc_html__('Upload Image', 'slide'); ?>" />
	<input id="lc_swp_remove_copyright_bg_img_button" type="button" class="button" value="<?php echo esc_html__('Remove Image', 'slide'); ?>" />
	<p class="description">
		<?php echo esc_html__('Upload an image to be used as background for the footer copyright area.', 'slide'); ?>
	</p>

	<div id="lc_footer_copyright_bg_img_preview">
		<img class="lc_swp_copyright_bg_img_preview" src="<?php echo esc_url($lc_copyright_bg_img); ?>">
	</div>
<?php	
}

function SLIDE_SWP_side_menu_bgc_cbk() {
	$side_menu_bgc = SLIDE_SWP_get_theme_option('slide_theme_footer_options', 'lc_side_menu_bg_color');
	$default_side_menu_bgc = 'rgba(23, 25, 41, 1)';

	if ('' == $side_menu_bgc) {
		$side_menu_bgc = $default_side_menu_bgc;
	}
?>

	<input type="text" id="lc_side_menu_bg_color" class="swp_new_settings_section alpha-color-picker-settings" name="slide_theme_footer_options[lc_side_menu_bg_color]" value="<?php echo esc_html($side_menu_bgc); ?>" data-default-color="rgba(23, 25, 41, 1)" data-show-opacity="true" />

	<p class="description">
		<?php echo esc_html__('Background color for the side menu.', 'slide'); ?>
		<?php echo esc_html__('Side menu can be enabled by adding a widget to the side menu widget area. You can do this by going to Appearance - Widgets.', 'slide'); ?>
	</p>
<?php	
}

function SLIDE_SWP_side_menu_cs_cbk() {
	$side_menu_color_scheme = SLIDE_SWP_get_theme_option('slide_theme_footer_options', 'lc_side_menu_cs');
	if (empty($side_menu_color_scheme)) {
		$side_menu_color_scheme = 'white_on_black';
	}

	$side_menu_color_schemes = array(
		esc_html__('White On Black', 'slide')	=> 'white_on_black',
		esc_html__('Black on White', 'slide')	=> 'black_on_white'
	);
?>

	<select id="lc_side_menu_cs" name="slide_theme_footer_options[lc_side_menu_cs]">
		<?php SLIDE_SWP_render_select_options($side_menu_color_schemes, $side_menu_color_scheme); ?>
	</select>

	<p class="description">
		<?php echo esc_html__('Color scheme used for the side menu area.', 'slide'); ?>
		<?php echo esc_html__('White On Black - White Text On Dark Background.', 'slide'); ?>
		<?php echo esc_html__('Black On White - Black Text On White Background.', 'slide'); ?>
	</p>
<?php
}

/*
	Contact Options
*/
function SLIDE_SWP_lc_contact_address_cbk() {
	$contact_address = SLIDE_SWP_get_theme_option('slide_theme_contact_options', 'lc_contact_address');
?>
	<input type="text" size="200" id="lc_contact_address" name="slide_theme_contact_options[lc_contact_address]" value="<?php echo esc_attr($contact_address); ?>" />
<?php
}

function SLIDE_SWP_lc_contact_phone_cbk() {
	$contact_phone = SLIDE_SWP_get_theme_option('slide_theme_contact_options', 'lc_contact_phone');
?>
	<input type="text" size="50" id="lc_contact_phone" name="slide_theme_contact_options[lc_contact_phone]" value="<?php echo esc_attr($contact_phone); ?>" />
<?php	
}

function SLIDE_SWP_lc_contact_phone2_cbk() {
	$contact_phone = SLIDE_SWP_get_theme_option('slide_theme_contact_options', 'lc_contact_phone2');
?>
	<input type="text" size="50" id="lc_contact_phone2" name="slide_theme_contact_options[lc_contact_phone2]" value="<?php echo esc_attr($contact_phone); ?>" />
<?php	
}

function SLIDE_SWP_lc_contact_fax_cbk() {
	$contact_fax = SLIDE_SWP_get_theme_option('slide_theme_contact_options', 'lc_contact_fax');
?>
	<input type="text" size="50" id="lc_contact_fax" name="slide_theme_contact_options[lc_contact_fax]" value="<?php echo esc_attr($contact_fax); ?>" />
<?php
}

function SLIDE_SWP_lc_contact_email_cbk() {
	$contact_email = sanitize_email(SLIDE_SWP_get_theme_option('slide_theme_contact_options', 'lc_contact_email'));
?>
	<input type="text" size="50" id="lc_contact_email" name="slide_theme_contact_options[lc_contact_email]" value="<?php echo esc_attr($contact_email); ?>" />
	<p class="description">
		<?php
		echo esc_html__("This is the email address shown on contact page.", 'slide');
		?> <br> <?php
		echo esc_html__("To set the recipient email for the contact form, please go to Settings - Slide Music Core Settings.", 'slide');
		?>
	</p>
<?php
}


/*
	Fonts Options
*/
function SLIDE_SWP_lc_fonts_custom_default_cbk() {
	$fonts_custom_default = SLIDE_SWP_get_theme_option('slide_theme_fonts_options', 'lc_fonts_custom_default');
	if (empty($fonts_custom_default)) {
		$fonts_custom_default = 'use_defaults';
	}

	$fonts_usage = array(
		esc_html__('Use Theme Defaults', 'slide')	=> 'use_defaults',
		esc_html__('Use Custom Fonts', 'slide')	=> 'use_custom'
	);
?>

	<select id="lc_fonts_custom_default" name="slide_theme_fonts_options[lc_fonts_custom_default]">
		<?php SLIDE_SWP_render_select_options($fonts_usage, $fonts_custom_default); ?>
	</select>

	<p class="description">
		<?php echo esc_html__('Choose to use custom fonts for Slide Theme.', 'slide'); ?>
	</p>

<?php
}

function SLIDE_SWP_lc_primary_font_cbk() {
	$primary_font = SLIDE_SWP_get_theme_option('slide_theme_fonts_options', 'lc_primary_font');
	if (empty($primary_font)) {
		$primary_font = 'Roboto';
	}

	$font_families = SLIDE_SWP_get_google_fonts_array();

?>
	<select id="lc_primary_font" name="slide_theme_fonts_options[lc_primary_font]">
		<?php SLIDE_SWP_render_select_options($font_families, $primary_font); ?>
	</select>

	<p class="description">
		<?php echo esc_html__('Choose the primary font.', 'slide'); ?>
	</p>	
<?php
}

function SLIDE_SWP_lc_secondary_font_cbk() {
	$secondary_font = SLIDE_SWP_get_theme_option('slide_theme_fonts_options', 'lc_secondary_font');
	if (empty($secondary_font)) {
		$secondary_font = 'Roboto';
	}

	$font_families = SLIDE_SWP_get_google_fonts_array();

?>
	<select id="lc_secondary_font" name="slide_theme_fonts_options[lc_secondary_font]">
		<?php SLIDE_SWP_render_select_options($font_families, $secondary_font); ?>
	</select>

	<p class="description">
		<?php echo esc_html__('Choose the secondary font.', 'slide'); ?>
	</p>	
<?php	
}


/*
	UTILS FOR THEME SETTINGS
*/
function SLIDE_SWP_get_theme_option($option_group, $option_name) 
{
	$options = get_option($option_group);

	if (isset($options[$option_name])) {
		return $options[$option_name];
	}

	return '';
}

function SLIDE_SWP_render_select_options($options, $selected) {
	if (empty($selected)) {
		return;
	}

	foreach($options as $key => $value) {
		if ($value == $selected) {
			?>
			<option value="<?php echo esc_attr($value); ?>" selected="selected"> <?php echo esc_attr($key); ?> </option>
			<?php
		} else {
			?>
			<option value="<?php echo esc_attr($value); ?>"> <?php echo esc_attr($key); ?> </option>
			<?php
		}
	}
}

/*
	Get all google fonts and creates an array like: 
	 array(
		'Open Sans',	=> 'Open Sans'
	);
*/
function SLIDE_SWP_get_google_fonts_array() {
	$str = SLIDE_SWP_get_contents(get_template_directory() . '/assets/google_fonts/fonts.json'); 
	$fonts_json = json_decode($str, true);

	$array_fonts = array();
	foreach($fonts_json as $font_json) {
		$array_fonts[$font_json['family']] = $font_json['family'];
	}

	return $array_fonts;
}