<?php
/*
	Template Name: Page Photo Gallery
*/
?>

<?php get_header(); ?>

<?php
	/*output the page content if there is any*/
	if (have_posts()) : while (have_posts()) : the_post();
		$content = trim(get_the_content());
		if (!empty($content)) {
		?>
			<div class="lc_content_full lc_swp_boxed lc_basic_content_padding">
				<?php the_content(); ?>
				<?php get_template_part('views/utils/sharing_icons'); ?>
			</div>
		<?php
		}
	endwhile;endif;
?>	

<?php
	if (get_query_var('paged')) {
		$paged = get_query_var('paged'); 
	} elseif (get_query_var('page')) { 
		$paged = get_query_var('page'); 
	} else {
		$paged = 1; 
	}

	$posts_per_page = get_option('posts_per_page');
	$offset = ($paged - 1) * $posts_per_page;

	$args = array(
		'numberposts'	=> -1,
		'posts_per_page'   => $posts_per_page,
		'paged'			   => $paged,
		'offset'           => $offset,
		'orderby'          => 'post_date',
		'order'            => 'DESC',
		'post_type'        => 'js_photo_albums',
		'post_status'      => 'publish',
		'suppress_filters' => false
	);	
	$keep_old_wp_query = $wp_query;

	$wp_query= null;
	$wp_query = new WP_Query();
	$wp_query->query($args);

	$container_class = 'lc_content_full photo_gallery_container lc_swp_boxed';
	$single_item_template = "views/archive/gallery_item";
	$items_on_row = 3;

	if ($wp_query->have_posts()) {
		$item_count = 0;
	?>	
		<div class="<?php echo esc_attr($container_class); ?>">
			<?php
			while ($wp_query->have_posts()) : the_post();
				$item_order = $item_count % $items_on_row;
				if (0 == $item_order) { ?> <div class="photo_gallery_row clearfix"> <?php }
					set_query_var('item_order', $item_order);
					set_query_var('items_on_row', $items_on_row);
					get_template_part($single_item_template);
				if (($items_on_row - 1) == $item_order) { ?> </div> <?php }
				$item_count++;
			endwhile;
			?>
		</div>
	<?php
	}
	$wp_query = null; $wp_query = $keep_old_wp_query;
?>


<?php get_footer(); ?>