<?php
	/*
		query var:
			$lc_masonry_brick_class
	*/

	
	$thumbnail_class	= has_post_thumbnail() ? 'has_thumbnail' : 'no_thumbnail';
	$post_classes 		= 'post_item ' . $lc_masonry_brick_class . " " . $thumbnail_class;
	$masonry_excerpt_length = 18;
?>

<article <?php post_class($post_classes);?>>
	<?php if (has_post_thumbnail()) { ?>
		<a href="<?php the_permalink(); ?>">
			<?php the_post_thumbnail('full', array('class' => 'lc_masonry_thumbnail_image')); ?>
		</a>
	<?php } ?>

	<div class="post_item_details <?php echo esc_attr($thumbnail_class) ?>">
		<div class="post_item_meta lc_post_meta masonry_post_meta lc_vibrant_color">
			<?php echo get_the_date(get_option('date_format')); ?>
		</div>

		<a href="<?php the_permalink(); ?>">
			<h2 class="lc_post_title transition4 masonry_post_title">
				<?php the_title(); ?>
			</h2>
		</a>

		<div class="lc_post_excerpt masonry_excerpt">
			<?php
				$default_excerpt = get_the_excerpt();
				echo "<p>".wp_trim_words($default_excerpt, $masonry_excerpt_length)."</p>";
			?>
		</div>

		<div class="masonry_read_more swp_slide_link">
			<a href="<?php the_permalink(); ?>" class="masonry_read_more">
				<?php echo esc_html__("Read more", 'slide'); ?>
				<span class="swp_before_right_arrow transition4"></span><span class="swp_arrow swp_arrow_right"></span>
			</a>
		</div>
	</div>
</article>