<?php
	$header_width = esc_attr(SLIDE_SWP_get_header_footer_width());
	/*create class: lc_swp_full or lc_swp_boxed*/
	$header_width = 'lc_swp_'.$header_width; 

	/*sticky menu*/
	$header_class = 'header_classic_menu_left';
	if (SLIDE_SWP_is_sticky_menu()) {
		$header_class .= ' lc_sticky_menu';
	}

	/*custom menu styling*/
	$page_logo = $menu_bar_bg = $menu_txt_col = "";
	$has_custom_menu_styling = SLIDE_SWP_get_page_custom_menu_style($page_logo, $menu_bar_bg, $menu_txt_col);

	if ($has_custom_menu_styling) {
		$header_class .= ' cust_page_menu_style';
	}	
?>

<header id="lc_page_header" class="<?php echo esc_attr($header_class); ?>" data-menubg="<?php echo esc_attr($menu_bar_bg); ?>" data-menucol="<?php echo esc_attr($menu_txt_col); ?>">
	<div class="header_inner lc_wide_menu <?php echo esc_attr($header_width); ?>">
		<div id="logo" class="classic_menu_left">
			<?php
				$logo_img = SLIDE_SWP_get_user_logo_img();
				if (!empty($logo_img)) {
					?>

					<a href="<?php echo esc_url(home_url()); ?>" class="global_logo">
						<img src="<?php echo esc_url($logo_img); ?>" alt="<?php bloginfo('name'); ?>">
					</a>

					<?php
				} else {
					?>

					<a href="<?php echo esc_url(home_url()); ?>" class="global_logo"> <?php bloginfo('name'); ?></a>

					<?php
				}

				/*custom page related logo*/
				if (!empty($page_logo)) {
				?>
					<a href="<?php echo esc_url(home_url('/')); ?>" class="cust_page_logo">
						<img src="<?php echo esc_url($page_logo); ?>" alt="<?php bloginfo('name'); ?>">
					</a>
				<?php
				}				
			?>
		</div>

		<div class="classic_header_icons">
			<?php $icons_social_cart_css = SLIDE_SWP_has_side_menu() ? "icons_social_cart has_side_menu" : "icons_social_cart"; ?>
			<div class="<?php echo esc_attr($icons_social_cart_css); ?>">
				<?php 
					/*'url', 'icon'*/
					$user_profiles = array();
					$user_profiles = SLIDE_SWP_get_available_social_profiles();

					foreach ($user_profiles as $social_profile) {
						?>
						
							<div class="classic_header_icon lc_social_icon">
								<a href="<?php echo esc_url($social_profile['url']); ?>" target="_blank">
									<i class="fab fa-<?php echo esc_attr($social_profile['icon']); ?>"></i>
								</a>
							</div>
						<?php
					}
				?>

				<?php 
				if (SLIDE_SWP_is_woocommerce_active()) {
				?>
					<div class="classic_header_icon swp_cart_icon">
						<a class="cart-contents" href="<?php echo wc_get_cart_url(); ?>" title="<?php esc_html__('View your shopping cart', 'slide'); ?>">
							<i class="fas fa-shopping-bag" aria-hidden="true"></i>
							<span class="cart-contents-count lc_swp_vibrant_bgc">
								<?php echo WC()->cart->get_cart_contents_count(); ?>
							</span>
						</a>
					</div>
				<?php
				}
				?>				

				<?php if (SLIDE_SWP_show_search_on_menu()) { ?>
				<div class="classic_header_icon lc_search trigger_global_search vibrant_hover transition4">
					<span class="lnr lnr-magnifier"></span>
				</div>
				<?php } ?>
			</div>
			<?php 
				get_template_part("views/utils/hmb_menu");
			?>

		</div>		

		<?php
		/*render main menu*/
		wp_nav_menu(
			array(
				'theme_location'	=> 'main-menu', 
				'container'			=> 'nav',
				'container_class'	=> 'classic_menu classic_menu_left',
				'fallback_cb'    => 'SLIDE_SWP_fallback_menu'
			)
		);
		?>
	</div>
	<?php 
	/*mobile menu*/
	get_template_part('views/menu/mobile_menu'); 
	?>
</header>