<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<?php 
	global $avia_config;

	/*
	 * outputs a rel=follow or nofollow tag to circumvent google duplicate content for archives
	 * located in framework/php/function-set-avia-frontend.php
	 */
	 if (function_exists('avia_set_follow')) { echo avia_set_follow(); }
	 
?>


<!-- page title, displayed in your browser bar -->
<title><?php bloginfo('name'); ?> | <?php is_home() ? bloginfo('description') : wp_title(''); ?></title>


<!-- add feeds, pingback and stuff-->
<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="alternate" type="application/rss+xml" title="<?php echo get_bloginfo('name'); ?> RSS2 Feed" href="<?php avia_option('feedburner',get_bloginfo('rss2_url')); ?>" />
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />


<!-- add css stylesheets -->	
<link rel="stylesheet" type="text/css" media="all" href="<?php bloginfo( 'stylesheet_url' ); ?>" />
<link rel="stylesheet" href="<?php echo get_bloginfo('template_url'); ?>/js/prettyPhoto/css/prettyPhoto.css" type="text/css" media="screen"/>
<link rel="stylesheet" href="<?php echo get_bloginfo('template_url'); ?>/js/projekktor/theme/style.css" type="text/css" media="screen"/>
<link rel="stylesheet" href="<?php echo get_bloginfo('template_url'); ?>/css/<?php avia_option('stylesheet', 'light-skin.css'); ?>" type="text/css" media="screen"/>
<link rel="stylesheet" href="<?php echo get_bloginfo('template_url'); ?>/css/shortcodes.css" type="text/css" media="screen"/>
<link rel="stylesheet" href="<?php echo get_bloginfo('template_url'); ?>/css/slideshow.css" type="text/css" media="screen"/>


<?php

	/* add javascript */
	wp_enqueue_script( 'jquery' );
	wp_enqueue_script( 'avia-default' );
	wp_enqueue_script( 'avia-prettyPhoto' );
	wp_enqueue_script( 'avia-html5-video' );
	wp_enqueue_script( 'avia_fade_slider' );
	wp_enqueue_script( 'avia-slider' );
	wp_enqueue_script( 'aviacordion' );


	/* We add some JavaScript to pages with the comment form
	 * to support sites with threaded comments (when in use).
	 */
	if ( is_singular() && get_option( 'thread_comments' ) ) { wp_enqueue_script( 'comment-reply' ); }
	
?>

<!-- plugin and theme output with wp_head() -->
<?php 

	/* Always have wp_head() just before the closing </head>
	 * tag of your theme, or you will break many plugins, which
	 * generally use this hook to add elements to <head> such
	 * as styles, scripts, and meta tags.
	 */
	 
	wp_head();
?>

<!-- custom.css file: use this file to add your own styles and overwrite the theme defaults -->
<link rel="stylesheet" href="<?php echo get_bloginfo('template_url'); ?>/css/custom.css" type="text/css" media="screen"/>
<!--[if lt IE 8]>
<style type='text/css'> .one_fourth	{ width:21.5%;} #main .container, #main, .post-entry-dynamic, .entry-content{ overflow: hidden; }</style>
<![endif]-->

</head>



<?php 
/*
 * prepare big slideshow if available
 * If we are displaying a dynamic template the slideshow might already be set
 * therefore we dont need to call it here
 */

if(!avia_special_dynamic_template())
{
	avia_template_set_page_layout();
	$slider = new avia_slideshow(avia_get_the_ID());
	$avia_config['slide_output'] =  $slider->display();
}

$extraClass = !empty($avia_config['slide_output']) ? 'slideshow_big_container' : "";


?>


<body id="top" <?php body_class(avia_get_option('boxed'). " ".avia_get_browser()); ?>>
	<div id='wrap_all'>
			

			<!-- ####### HEAD CONTAINER ####### -->
			<div class='container_wrap <?php echo $extraClass; ?>' id='header'>		
			
				<div class='submenu'>
				
					<div class='container'>
						<?php
						/*
						*	display the main navigation menu
						*   modify the output in your wordpress admin backend at appearance->menus
						*/
						$args = array('theme_location'=>'avia2', 'fallback_cb' => '');
						wp_nav_menu($args); 
						?>
					
					
						<ul class="social_bookmarks">
							<?php 
							//text snuippet (eg phone number)
							if($phone = avia_get_option('phone_snippet')) echo "<li class='phone'>".$phone."</li>"; 
							
							//contact icon
							$contact_page_id = avia_get_option('email_page');
			                if (function_exists('icl_object_id')) $contact_page_id = icl_object_id($contact_page_id, 'page', true);  //wpml prepared
							if($contact_page_id) echo "<li class='mail'><a href='".get_permalink($contact_page_id)."'>".__('Send us Mail', 'avia_framework')."</a></li>";

							if($twitter = avia_get_option('twitter')) echo "<li class='twitter'><a href='http://twitter.com/".$twitter."'>".__('Follow us on Twitter', 'avia_framework')."</a></li>";
							if($facebook = avia_get_option('facebook')) echo "<li class='facebook'><a href='".$facebook."'>".__('Join our Facebook Group', 'avia_framework')."</a></li>";
							
							
							 ?>
							<li class='rss'><a href="<?php avia_option('feedburner',get_bloginfo('rss2_url')); ?>"><?php _e('Subscribe to our RSS Feed', 'avia_framework')?></a></li>

							<li class='search_site'><a href="#"><?php _e('Search Site', 'avia_framework')?></a>
							
								<?php 
								/*
								*	display the theme search form
								*   the tempalte file that is called is searchform.php in case you want to edit it
								*/
								get_search_form(); 
								?>
							
							</li>
							
									
						</ul>
						<!-- end social_bookmarks-->
					</div>
				</div>
			
				
				<div class='container main_menu'>
				
					<?php  
					/*
					*	display the theme logo by checking if the default css defined logo was overwritten in the backend.
					*   the function is located at framework/php/function-set-avia-frontend-functions.php in case you need to edit the output
					*/
					echo avia_logo();
					
					
					/*
					*	display the main navigation menu
					*   check if a description for submenu items was added and change the menu class accordingly
					*   modify the output in your wordpress admin backend at appearance->menus
					*/
					$args = array(	'echo'=> false, 
									'fallback_cb' => 'avia_fallback_menu', 
									'theme_location' => 'avia', 
									'menu_class' => 'menu', 
									'walker' => new avia_description_walker()
								);


					$menu = wp_nav_menu($args); 
					if(strpos($menu, 'main-menu-description') === false  )
					{	
						$menu = str_replace('class="menu"','class="menu no_description_menu"', $menu); 
					}
					echo $menu;
					
					?>

				</div>
				<!-- end container-->
				
				<?php  	
					
					//display slideshow big if one is available	
					if(!empty($avia_config['slide_output'])) echo "<div class='container slideshow_big'>".$avia_config['slide_output']."</div>";	
					
					//if we dont are located on teh frontpge and if there is no big slideshow availabel display breadcrumb
					if(!is_front_page() && empty($avia_config['slide_output'])) 
					{
						echo "<div id='breadcrumb_wrapper' class='container'>";
						new avia_breadcrumb(array('delimiter' => '/')); 
						echo "</div>";
					}	
				?>
				
				
				
			
			
			</div>
			<!-- end container_wrap_header -->
			
			<!-- ####### END HEAD CONTAINER ####### -->
			
			
			
			
			
			

			